/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.LinkedList;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.Label;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.util.GUtil;

public class ConsoleBackedProgressRenderer
implements OutputEventListener {
    private final OutputEventListener listener;
    private final Console console;
    private final LinkedList<Operation> operations = new LinkedList();
    private Label statusBar;

    public ConsoleBackedProgressRenderer(OutputEventListener outputEventListener, Console console) {
        this.listener = outputEventListener;
        this.console = console;
    }

    public void onOutput(OutputEvent outputEvent) {
        if (outputEvent instanceof ProgressStartEvent) {
            ProgressStartEvent progressStartEvent = (ProgressStartEvent)outputEvent;
            this.operations.addLast(new Operation(progressStartEvent.getShortDescription(), progressStartEvent.getStatus()));
            this.updateText();
        } else if (outputEvent instanceof ProgressCompleteEvent) {
            this.operations.removeLast();
            this.updateText();
        } else if (outputEvent instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)outputEvent;
            this.operations.getLast().status = progressEvent.getStatus();
            this.updateText();
        }
        this.listener.onOutput(outputEvent);
    }

    private void updateText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Operation operation : this.operations) {
            String string = operation.getMessage();
            if (string == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("> ");
            stringBuilder.append(string);
        }
        if (this.statusBar == null) {
            this.statusBar = this.console.getStatusBar();
        }
        this.statusBar.setText(stringBuilder.toString());
    }

    private static class Operation {
        private final String shortDescription;
        private String status;

        private Operation(String string, String string2) {
            this.shortDescription = string;
            this.status = string2;
        }

        String getMessage() {
            if (GUtil.isTrue(this.status)) {
                return this.status;
            }
            if (GUtil.isTrue(this.shortDescription)) {
                return this.shortDescription;
            }
            return null;
        }
    }
}

