/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.AbstractStyledTextOutput;

public class BufferingStyledTextOutput
extends AbstractStyledTextOutput {
    private final List<Action<StyledTextOutput>> events = new ArrayList<Action<StyledTextOutput>>();
    private boolean hasContent;

    public void writeTo(StyledTextOutput styledTextOutput) {
        for (Action<StyledTextOutput> action : this.events) {
            action.execute(styledTextOutput);
        }
        this.events.clear();
    }

    protected void doStyleChange(StyledTextOutput.Style style) {
        if (!this.events.isEmpty() && this.events.get(this.events.size() - 1) instanceof ChangeStyleAction) {
            this.events.remove(this.events.size() - 1);
        }
        this.events.add(new ChangeStyleAction(style));
    }

    protected void doAppend(final String string) {
        if (string.length() == 0) {
            return;
        }
        this.hasContent = true;
        this.events.add(new Action<StyledTextOutput>(){

            @Override
            public void execute(StyledTextOutput styledTextOutput) {
                styledTextOutput.text(string);
            }
        });
    }

    public boolean getHasContent() {
        return this.hasContent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeStyleAction
    implements Action<StyledTextOutput> {
        private final StyledTextOutput.Style style;

        public ChangeStyleAction(StyledTextOutput.Style style) {
            this.style = style;
        }

        @Override
        public void execute(StyledTextOutput styledTextOutput) {
            styledTextOutput.style(this.style);
        }
    }
}

