/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.Flushable;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.fusesource.jansi.Ansi;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.SystemProperties;
import org.gradle.logging.internal.AbstractLineChoppingStyledTextOutput;
import org.gradle.logging.internal.ColorMap;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.Label;
import org.gradle.logging.internal.TextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnsiConsole
implements Console {
    private static final String EOL = SystemProperties.getLineSeparator();
    private final Appendable target;
    private final Flushable flushable;
    private LabelImpl statusBar;
    private final TextAreaImpl textArea;
    private final Screen container;
    private final ColorMap colorMap;

    public AnsiConsole(Appendable appendable, Flushable flushable, ColorMap colorMap) {
        this.target = appendable;
        this.flushable = flushable;
        this.colorMap = colorMap;
        this.container = new Screen();
        this.textArea = new TextAreaImpl(this.container);
    }

    @Override
    public Label getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new LabelImpl(this.container);
            this.render(new Action<Ansi>(){

                @Override
                public void execute(Ansi ansi) {
                    AnsiConsole.this.textArea.onDeactivate(ansi);
                    AnsiConsole.this.statusBar.onActivate(ansi);
                }
            });
        }
        return this.statusBar;
    }

    @Override
    public TextArea getMainArea() {
        return this.textArea;
    }

    private void render(Action<Ansi> action) {
        Ansi ansi = this.createAnsi();
        action.execute(ansi);
        try {
            this.target.append(ansi.toString());
            this.flushable.flush();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    Ansi createAnsi() {
        return Ansi.ansi();
    }

    private class TextAreaImpl
    extends AbstractLineChoppingStyledTextOutput
    implements TextArea,
    Widget {
        private final Container container;
        private int width;
        boolean extraEol;

        private TextAreaImpl(Container container) {
            this.container = container;
        }

        public void onDeactivate(Ansi ansi) {
            if (this.width > 0) {
                ansi.newline();
                this.extraEol = true;
            }
        }

        public void onActivate(Ansi ansi) {
            if (this.extraEol) {
                ansi.cursorUp(1);
                ansi.cursorRight(this.width);
                this.extraEol = false;
            }
        }

        protected void doLineText(final CharSequence charSequence, final boolean bl) {
            if (charSequence.length() == 0) {
                return;
            }
            this.container.redraw(this, new Action<Ansi>(){

                @Override
                public void execute(Ansi ansi) {
                    ColorMap.Color color = AnsiConsole.this.colorMap.getColourFor(TextAreaImpl.this.getStyle());
                    color.on(ansi);
                    if (bl) {
                        TextAreaImpl.this.width = 0;
                        TextAreaImpl.this.extraEol = false;
                    } else {
                        TextAreaImpl.this.width += charSequence.length();
                    }
                    ansi.a(charSequence.toString());
                    color.off(ansi);
                }
            });
        }
    }

    private class LabelImpl
    implements Label,
    Widget {
        private final Container container;
        private String text = "";
        private String displayedText = "";

        public LabelImpl(Container container) {
            this.container = container;
        }

        public void setText(String string) {
            if (string.equals(this.text)) {
                return;
            }
            this.text = string;
            this.container.redraw(this, new Action<Ansi>(){

                @Override
                public void execute(Ansi ansi) {
                    LabelImpl.this.draw(ansi);
                }
            });
        }

        public void close() {
            this.container.close(this);
        }

        public void onDeactivate(Ansi ansi) {
            if (this.displayedText.length() > 0) {
                ansi.cursorLeft(this.displayedText.length());
                ansi.eraseLine(Ansi.Erase.FORWARD);
                this.displayedText = "";
            }
        }

        public void onActivate(Ansi ansi) {
            this.draw(ansi);
        }

        public void draw(Ansi ansi) {
            String string = StringUtils.getCommonPrefix((String[])new String[]{this.text, this.displayedText});
            if (string.length() < this.displayedText.length()) {
                ansi.cursorLeft(this.displayedText.length() - string.length());
            }
            if (string.length() < this.text.length()) {
                ColorMap.Color color = AnsiConsole.this.colorMap.getStatusBarColor();
                color.on(ansi);
                ansi.a(this.text.substring(string.length()));
                color.off(ansi);
            }
            if (this.displayedText.length() > this.text.length()) {
                ansi.eraseLine(Ansi.Erase.FORWARD);
            }
            this.displayedText = this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Screen
    implements Container {
        private Screen() {
        }

        @Override
        public void redraw(Widget widget, final Action<Ansi> action) {
            if (widget == AnsiConsole.this.textArea) {
                AnsiConsole.this.render(new Action<Ansi>(){

                    @Override
                    public void execute(Ansi ansi) {
                        if (AnsiConsole.this.statusBar != null) {
                            AnsiConsole.this.statusBar.onDeactivate(ansi);
                            AnsiConsole.this.textArea.onActivate(ansi);
                        }
                        action.execute(ansi);
                        if (AnsiConsole.this.statusBar != null) {
                            AnsiConsole.this.textArea.onDeactivate(ansi);
                            AnsiConsole.this.statusBar.onActivate(ansi);
                        }
                    }
                });
            } else {
                assert (widget == AnsiConsole.this.statusBar);
                AnsiConsole.this.render(new Action<Ansi>(){

                    @Override
                    public void execute(Ansi ansi) {
                        action.execute(ansi);
                    }
                });
            }
        }

        @Override
        public void close(Widget widget) {
            if (widget == AnsiConsole.this.textArea) {
                throw new UnsupportedOperationException();
            }
            if (widget == AnsiConsole.this.statusBar) {
                AnsiConsole.this.render(new Action<Ansi>(){

                    @Override
                    public void execute(Ansi ansi) {
                        AnsiConsole.this.statusBar.onDeactivate(ansi);
                        AnsiConsole.this.textArea.onActivate(ansi);
                        AnsiConsole.this.statusBar = null;
                    }
                });
            }
        }
    }

    private static interface Widget {
        public void onActivate(Ansi var1);

        public void onDeactivate(Ansi var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Container {
        public void redraw(Widget var1, Action<Ansi> var2);

        public void close(Widget var1);
    }
}

