/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.SystemProperties;
import org.gradle.logging.StyledTextOutput;

public abstract class AbstractStyledTextOutput
implements StyledTextOutput,
StandardOutputListener {
    private StyledTextOutput.Style style = StyledTextOutput.Style.Normal;

    public StyledTextOutput append(char c) {
        this.text(String.valueOf(c));
        return this;
    }

    public StyledTextOutput append(CharSequence charSequence) {
        this.text(charSequence == null ? "null" : charSequence);
        return this;
    }

    public StyledTextOutput append(CharSequence charSequence, int n, int n2) {
        this.text(charSequence == null ? "null" : charSequence.subSequence(n, n2));
        return this;
    }

    public StyledTextOutput format(String string, Object ... objectArray) {
        this.text(String.format(string, objectArray));
        return this;
    }

    public StyledTextOutput println(Object object) {
        this.text(object);
        this.println();
        return this;
    }

    public StyledTextOutput formatln(String string, Object ... objectArray) {
        this.format(string, objectArray);
        this.println();
        return this;
    }

    public void onOutput(CharSequence charSequence) {
        this.text(charSequence);
    }

    public StyledTextOutput println() {
        this.text(SystemProperties.getLineSeparator());
        return this;
    }

    public StyledTextOutput text(Object object) {
        this.doAppend(object == null ? "null" : object.toString());
        return this;
    }

    public StyledTextOutput exception(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        this.text(stringWriter.toString());
        return this;
    }

    public StyledTextOutput withStyle(StyledTextOutput.Style style) {
        return new StyleOverrideTextOutput(style, this);
    }

    public StyledTextOutput style(StyledTextOutput.Style style) {
        if (style != this.style) {
            this.style = style;
            this.doStyleChange(style);
        }
        return this;
    }

    public StyledTextOutput.Style getStyle() {
        return this.style;
    }

    protected abstract void doAppend(String var1);

    protected void doStyleChange(StyledTextOutput.Style style) {
    }

    private static class StyleOverrideTextOutput
    implements StyledTextOutput {
        private final StyledTextOutput.Style style;
        private final AbstractStyledTextOutput textOutput;

        public StyleOverrideTextOutput(StyledTextOutput.Style style, AbstractStyledTextOutput abstractStyledTextOutput) {
            this.style = style;
            this.textOutput = abstractStyledTextOutput;
        }

        public StyledTextOutput append(char c) {
            StyledTextOutput.Style style = this.textOutput.getStyle();
            this.textOutput.style(this.style).append(c).style(style);
            return this;
        }

        public StyledTextOutput append(CharSequence charSequence) {
            StyledTextOutput.Style style = this.textOutput.getStyle();
            this.textOutput.style(this.style).append(charSequence).style(style);
            return this;
        }

        public StyledTextOutput append(CharSequence charSequence, int n, int n2) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput style(StyledTextOutput.Style style) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput withStyle(StyledTextOutput.Style style) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput text(Object object) {
            StyledTextOutput.Style style = this.textOutput.getStyle();
            this.textOutput.style(this.style).text(object).style(style);
            return this;
        }

        public StyledTextOutput println(Object object) {
            StyledTextOutput.Style style = this.textOutput.getStyle();
            this.textOutput.style(this.style).text(object).style(style).println();
            return this;
        }

        public StyledTextOutput format(String string, Object ... objectArray) {
            StyledTextOutput.Style style = this.textOutput.getStyle();
            this.textOutput.style(this.style).format(string, objectArray).style(style);
            return this;
        }

        public StyledTextOutput formatln(String string, Object ... objectArray) {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput println() {
            throw new UnsupportedOperationException();
        }

        public StyledTextOutput exception(Throwable throwable) {
            throw new UnsupportedOperationException();
        }
    }
}

