/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.listener;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyCreationProxy<T> {
    private final T source;

    public LazyCreationProxy(Class<T> clazz, Factory<? extends T> factory) {
        this.source = clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new LazyInvocationHandler(factory)));
    }

    public T getSource() {
        return this.source;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyInvocationHandler
    implements InvocationHandler {
        private Object target;
        private final Factory<?> factory;

        public LazyInvocationHandler(Factory<?> factory) {
            this.factory = factory;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (this.target == null) {
                this.target = this.factory.create();
            }
            try {
                return method.invoke(this.target, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }
    }
}

