/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.listener;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.messaging.dispatch.BroadcastDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListenerManager
implements ListenerManager {
    private final Set<Object> allListeners = new LinkedHashSet<Object>();
    private final Set<Object> allLoggers = new LinkedHashSet<Object>();
    private final Map<Class<?>, ListenerBroadcast> broadcasters = new HashMap();
    private final Map<Class<?>, LoggerDispatch> loggers = new HashMap();
    private final Map<Class<?>, BroadcastDispatch> dispatchers = new HashMap();
    private final Object lock = new Object();
    private final DefaultListenerManager parent;

    public DefaultListenerManager() {
        this(null);
    }

    private DefaultListenerManager(DefaultListenerManager defaultListenerManager) {
        this.parent = defaultListenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.allListeners.add(object)) {
                for (BroadcastDispatch broadcastDispatch : this.dispatchers.values()) {
                    this.maybeAddToDispatcher(broadcastDispatch, object);
                }
            }
        }
    }

    @Override
    public void addListener(Class<?> clazz, String string, Closure closure) {
        this.addListener(new ClosureListener(clazz, string, closure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.allListeners.remove(object)) {
                for (BroadcastDispatch broadcastDispatch : this.dispatchers.values()) {
                    broadcastDispatch.remove(object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useLogger(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.allLoggers.add(object)) {
                for (LoggerDispatch loggerDispatch : this.loggers.values()) {
                    loggerDispatch.maybeSetLogger(object);
                }
            }
        }
    }

    @Override
    public <T> T getBroadcaster(Class<T> clazz) {
        return this.getBroadcasterInternal(clazz).getSource();
    }

    @Override
    public <T> ListenerBroadcast<T> createAnonymousBroadcaster(Class<T> clazz) {
        ListenerBroadcast<T> listenerBroadcast = new ListenerBroadcast<T>(clazz);
        listenerBroadcast.add(this.getBroadcasterInternal(clazz).getSource());
        return listenerBroadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ListenerBroadcast<T> getBroadcasterInternal(Class<T> clazz) {
        Object object = this.lock;
        synchronized (object) {
            ListenerBroadcast<T> listenerBroadcast = this.broadcasters.get(clazz);
            if (listenerBroadcast == null) {
                listenerBroadcast = new ListenerBroadcast<T>(clazz);
                listenerBroadcast.add(this.getLogger(clazz));
                listenerBroadcast.add(this.getDispatcher(clazz));
                if (this.parent != null) {
                    listenerBroadcast.add(this.parent.getDispatcher(clazz));
                }
                this.broadcasters.put(clazz, listenerBroadcast);
            }
            return listenerBroadcast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BroadcastDispatch<T> getDispatcher(Class<T> clazz) {
        Object object = this.lock;
        synchronized (object) {
            BroadcastDispatch<T> broadcastDispatch = this.dispatchers.get(clazz);
            if (broadcastDispatch == null) {
                broadcastDispatch = new BroadcastDispatch<T>(clazz);
                this.dispatchers.put(clazz, broadcastDispatch);
                for (Object object2 : this.allListeners) {
                    this.maybeAddToDispatcher(broadcastDispatch, object2);
                }
            }
            return broadcastDispatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerDispatch getLogger(Class<?> clazz) {
        Object object = this.lock;
        synchronized (object) {
            LoggerDispatch loggerDispatch = this.loggers.get(clazz);
            if (loggerDispatch == null) {
                loggerDispatch = new LoggerDispatch(clazz, this.parent == null ? null : this.parent.getLogger(clazz));
                for (Object object2 : this.allLoggers) {
                    loggerDispatch.maybeSetLogger(object2);
                }
                this.loggers.put(clazz, loggerDispatch);
            }
            return loggerDispatch;
        }
    }

    private void maybeAddToDispatcher(BroadcastDispatch broadcastDispatch, Object object) {
        if (object instanceof ClosureListener) {
            ClosureListener closureListener = (ClosureListener)object;
            if (broadcastDispatch.getType().isAssignableFrom(closureListener.listenerType)) {
                broadcastDispatch.add(closureListener.method, closureListener.closure);
            }
        } else if (broadcastDispatch.getType().isInstance(object)) {
            broadcastDispatch.add(object);
        }
    }

    @Override
    public ListenerManager createChild() {
        return new DefaultListenerManager(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggerDispatch
    implements Dispatch<MethodInvocation> {
        private final Class<?> type;
        private Dispatch<MethodInvocation> dispatch;

        private LoggerDispatch(Class<?> clazz, LoggerDispatch loggerDispatch) {
            this.type = clazz;
            this.dispatch = loggerDispatch;
        }

        @Override
        public void dispatch(MethodInvocation methodInvocation) {
            if (this.dispatch != null) {
                this.dispatch.dispatch(methodInvocation);
            }
        }

        public void maybeSetLogger(Object object) {
            if (this.type.isInstance(object)) {
                this.dispatch = new ReflectionDispatch(object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClosureListener {
        final Class<?> listenerType;
        final String method;
        final Closure closure;

        private ClosureListener(Class<?> clazz, String string, Closure closure) {
            this.listenerType = clazz;
            this.method = string;
            this.closure = closure;
        }
    }
}

