/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;

public class BuildLayoutFactory {
    public BuildLayout getLayoutFor(File file, boolean bl) {
        return this.getLayoutFor(file, bl ? null : file.getParentFile());
    }

    public BuildLayout getLayoutFor(BuildLayoutConfiguration buildLayoutConfiguration) {
        if (buildLayoutConfiguration.isUseEmptySettings()) {
            return new BuildLayout(buildLayoutConfiguration.getCurrentDir(), buildLayoutConfiguration.getCurrentDir(), null);
        }
        if (buildLayoutConfiguration.getSettingsFile() != null) {
            return new BuildLayout(buildLayoutConfiguration.getCurrentDir(), buildLayoutConfiguration.getCurrentDir(), buildLayoutConfiguration.getSettingsFile());
        }
        File file = buildLayoutConfiguration.getCurrentDir();
        boolean bl = buildLayoutConfiguration.isSearchUpwards();
        return this.getLayoutFor(file, bl ? null : file.getParentFile());
    }

    BuildLayout getLayoutFor(File file, File file2) {
        File file3 = new File(file, "settings.gradle");
        if (file3.isFile()) {
            return this.layout(file, file, file3);
        }
        for (File file4 = file.getParentFile(); file4 != null && !file4.equals(file2); file4 = file4.getParentFile()) {
            file3 = new File(file4, "settings.gradle");
            if (file3.isFile()) {
                return this.layout(file4, file4, file3);
            }
            file3 = new File(file4, "master/settings.gradle");
            if (!file3.isFile()) continue;
            return this.layout(file4, file3.getParentFile(), file3);
        }
        return this.layout(file, file);
    }

    private BuildLayout layout(File file, File file2) {
        return new BuildLayout(file, file2, null);
    }

    private BuildLayout layout(File file, File file2, File file3) {
        return new BuildLayout(file, file2, file3);
    }
}

