/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URLClassLoader;
import org.gradle.StartParameter;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.AbstractProjectSpec;
import org.gradle.initialization.BuildFileProjectSpec;
import org.gradle.initialization.BuildSourceBuilder;
import org.gradle.initialization.DefaultProjectSpec;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.ProjectDirectoryProjectSpec;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;

public class SettingsHandler {
    private ISettingsFinder settingsFinder;
    private SettingsProcessor settingsProcessor;
    private BuildSourceBuilder buildSourceBuilder;

    public SettingsHandler(ISettingsFinder iSettingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder) {
        this.settingsFinder = iSettingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradleInternal) {
        AbstractProjectSpec abstractProjectSpec;
        StartParameter startParameter = gradleInternal.getStartParameter();
        SettingsInternal settingsInternal = this.findSettingsAndLoadIfAppropriate(gradleInternal, startParameter);
        File file = startParameter.getProjectDir();
        File file2 = startParameter.getBuildFile();
        AbstractProjectSpec abstractProjectSpec2 = file2 != null ? new BuildFileProjectSpec(file2) : (abstractProjectSpec = file == null ? new DefaultProjectSpec(startParameter.getCurrentDir()) : new ProjectDirectoryProjectSpec(file));
        if (!abstractProjectSpec.containsProject(settingsInternal.getProjectRegistry())) {
            StartParameter startParameter2 = startParameter.newInstance();
            startParameter2.useEmptySettings();
            settingsInternal = this.findSettingsAndLoadIfAppropriate(gradleInternal, startParameter2);
            if (settingsInternal == null) {
                throw new InternalError("Empty settings file does not contain expected project.");
            }
            if (startParameter2.getBuildFile() != null) {
                ProjectDescriptor projectDescriptor = settingsInternal.getRootProject();
                assert (startParameter2.getBuildFile().getParentFile().equals(projectDescriptor.getProjectDir()));
                projectDescriptor.setBuildFileName(startParameter2.getBuildFile().getName());
            }
        }
        gradleInternal.getScriptClassLoader().addParent(settingsInternal.getClassLoader());
        return settingsInternal;
    }

    private SettingsInternal findSettingsAndLoadIfAppropriate(GradleInternal gradleInternal, StartParameter startParameter) {
        SettingsLocation settingsLocation = this.findSettings(startParameter);
        StartParameter startParameter2 = startParameter.newBuild();
        startParameter2.setCurrentDir(new File(settingsLocation.getSettingsDir(), "buildSrc"));
        URLClassLoader uRLClassLoader = this.buildSourceBuilder.buildAndCreateClassLoader(startParameter2);
        return this.loadSettings(gradleInternal, settingsLocation, uRLClassLoader, startParameter);
    }

    private SettingsLocation findSettings(StartParameter startParameter) {
        return this.settingsFinder.find(startParameter);
    }

    private SettingsInternal loadSettings(GradleInternal gradleInternal, SettingsLocation settingsLocation, URLClassLoader uRLClassLoader, StartParameter startParameter) {
        return this.settingsProcessor.process(gradleInternal, settingsLocation, uRLClassLoader, startParameter);
    }
}

