/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.SettingsFactory;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsScript;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluatingSettingsProcessor
implements SettingsProcessor {
    private static Logger logger = LoggerFactory.getLogger(ScriptEvaluatingSettingsProcessor.class);
    private final SettingsFactory settingsFactory;
    private final IGradlePropertiesLoader propertiesLoader;
    private final ScriptPluginFactory configurerFactory;

    public ScriptEvaluatingSettingsProcessor(ScriptPluginFactory scriptPluginFactory, SettingsFactory settingsFactory, IGradlePropertiesLoader iGradlePropertiesLoader) {
        this.configurerFactory = scriptPluginFactory;
        this.settingsFactory = settingsFactory;
        this.propertiesLoader = iGradlePropertiesLoader;
    }

    public SettingsInternal process(GradleInternal gradleInternal, SettingsLocation settingsLocation, URLClassLoader uRLClassLoader, StartParameter startParameter) {
        Clock clock = new Clock();
        Map<String, String> map = this.propertiesLoader.mergeProperties(Collections.<String, String>emptyMap());
        SettingsInternal settingsInternal = this.settingsFactory.createSettings(gradleInternal, settingsLocation.getSettingsDir(), settingsLocation.getSettingsScriptSource(), map, startParameter, uRLClassLoader);
        this.applySettingsScript(settingsLocation, uRLClassLoader, settingsInternal);
        logger.debug("Timing: Processing settings took: {}", (Object)clock.getTime());
        return settingsInternal;
    }

    private void applySettingsScript(SettingsLocation settingsLocation, ClassLoader classLoader, SettingsInternal settingsInternal) {
        ScriptPlugin scriptPlugin = this.configurerFactory.create(settingsLocation.getSettingsScriptSource());
        scriptPlugin.setClassLoader(classLoader);
        scriptPlugin.setScriptBaseClass(SettingsScript.class);
        scriptPlugin.apply(settingsInternal);
    }
}

