/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPropertySettingBuildLoader
implements BuildLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectPropertySettingBuildLoader.class);
    private final IGradlePropertiesLoader propertiesLoader;
    private final BuildLoader buildLoader;

    public ProjectPropertySettingBuildLoader(IGradlePropertiesLoader iGradlePropertiesLoader, BuildLoader buildLoader) {
        this.buildLoader = buildLoader;
        this.propertiesLoader = iGradlePropertiesLoader;
    }

    public void load(ProjectDescriptor projectDescriptor, GradleInternal gradleInternal) {
        this.buildLoader.load(projectDescriptor, gradleInternal);
        this.setProjectProperties(gradleInternal.getRootProject());
    }

    private void setProjectProperties(Project project) {
        this.addPropertiesToProject(project);
        for (Project project2 : project.getChildProjects().values()) {
            this.setProjectProperties(project2);
        }
    }

    private void addPropertiesToProject(Project project) {
        Properties properties = new Properties();
        File file = new File(project.getProjectDir(), "gradle.properties");
        LOGGER.debug("Looking for project properties from: {}", (Object)file);
        if (file.isFile()) {
            properties = GUtil.loadProperties(file);
            LOGGER.debug("Adding project properties (if not overwritten by user properties): {}", properties.keySet());
        } else {
            LOGGER.debug("project property file does not exists. We continue!");
        }
        Map<String, String> map = this.propertiesLoader.mergeProperties(new HashMap<Object, Object>(properties));
        ExtraPropertiesExtension extraPropertiesExtension = new DslObject(project).getExtensions().getExtraProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (project.hasProperty(entry.getKey())) {
                project.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            extraPropertiesExtension.set(entry.getKey(), entry.getValue());
        }
    }
}

