/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.AbstractProjectSpec;
import org.gradle.initialization.BuildFileProjectSpec;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.DefaultProjectSpec;
import org.gradle.initialization.ProjectDirectoryProjectSpec;

public class InstantiatingBuildLoader
implements BuildLoader {
    private final IProjectFactory projectFactory;

    public InstantiatingBuildLoader(IProjectFactory iProjectFactory) {
        this.projectFactory = iProjectFactory;
    }

    public void load(ProjectDescriptor projectDescriptor, GradleInternal gradleInternal) {
        this.createProjects(projectDescriptor, gradleInternal);
        this.attachDefaultProject(gradleInternal);
    }

    private void attachDefaultProject(GradleInternal gradleInternal) {
        File file = gradleInternal.getStartParameter().getProjectDir();
        File file2 = gradleInternal.getStartParameter().getBuildFile();
        AbstractProjectSpec abstractProjectSpec = file2 != null ? new BuildFileProjectSpec(file2) : (file == null ? new DefaultProjectSpec(gradleInternal.getStartParameter().getCurrentDir()) : new ProjectDirectoryProjectSpec(file));
        try {
            gradleInternal.setDefaultProject(abstractProjectSpec.selectProject(gradleInternal.getRootProject().getProjectRegistry()));
        }
        catch (InvalidUserDataException invalidUserDataException) {
            throw new GradleException(String.format("Could not select the default project for this build. %s", invalidUserDataException.getMessage()), invalidUserDataException);
        }
    }

    private void createProjects(ProjectDescriptor projectDescriptor, GradleInternal gradleInternal) {
        ProjectInternal projectInternal = this.projectFactory.createProject(projectDescriptor, null, gradleInternal);
        gradleInternal.setRootProject(projectInternal);
        this.addProjects(projectInternal, projectDescriptor, gradleInternal);
    }

    private void addProjects(ProjectInternal projectInternal, ProjectDescriptor projectDescriptor, GradleInternal gradleInternal) {
        for (ProjectDescriptor projectDescriptor2 : projectDescriptor.getChildren()) {
            ProjectInternal projectInternal2 = this.projectFactory.createProject(projectDescriptor2, projectInternal, gradleInternal);
            this.addProjects(projectInternal2, projectDescriptor2, gradleInternal);
        }
    }
}

