/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

public class DependencyResolutionLogger
implements DependencyResolutionListener {
    private final ProgressLoggerFactory loggerFactory;
    private ProgressLogger logger;

    public DependencyResolutionLogger(ProgressLoggerFactory progressLoggerFactory) {
        this.loggerFactory = progressLoggerFactory;
    }

    public void beforeResolve(ResolvableDependencies resolvableDependencies) {
        this.logger = this.loggerFactory.newOperation(DependencyResolutionLogger.class);
        this.logger.setDescription(String.format("Resolve %s", resolvableDependencies));
        this.logger.setShortDescription(String.format("Resolving %s", resolvableDependencies));
        this.logger.started();
    }

    public void afterResolve(ResolvableDependencies resolvableDependencies) {
        this.logger.completed();
        this.logger = null;
    }
}

