/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.initialization.IProjectDescriptorRegistry;
import org.gradle.util.GFileUtils;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectDescriptor
implements ProjectDescriptor,
ProjectIdentifier {
    private String name;
    private File dir;
    private DefaultProjectDescriptor parent;
    private Set<ProjectDescriptor> children = new LinkedHashSet<ProjectDescriptor>();
    private IProjectDescriptorRegistry projectDescriptorRegistry;
    private Path path;
    private String buildFileName = "build.gradle";

    public DefaultProjectDescriptor(DefaultProjectDescriptor defaultProjectDescriptor, String string, File file, IProjectDescriptorRegistry iProjectDescriptorRegistry) {
        this.parent = defaultProjectDescriptor;
        this.name = string;
        this.dir = GFileUtils.canonicalise(file);
        this.projectDescriptorRegistry = iProjectDescriptorRegistry;
        this.path = this.path(string);
        iProjectDescriptorRegistry.addProject(this);
        if (defaultProjectDescriptor != null) {
            defaultProjectDescriptor.getChildren().add(this);
        }
    }

    private Path path(String string) {
        if (this.isRootDescriptor()) {
            this.path = Path.ROOT;
            return this.path;
        }
        return this.parent.absolutePath(string);
    }

    private Path absolutePath(String string) {
        return this.path.resolve(string);
    }

    private boolean isRootDescriptor() {
        return this.parent == null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.projectDescriptorRegistry.changeDescriptorPath(this.path, this.path(string));
        this.name = string;
    }

    @Override
    public File getProjectDir() {
        return this.dir;
    }

    @Override
    public void setProjectDir(File file) {
        this.dir = GFileUtils.canonicalise(file);
    }

    @Override
    public DefaultProjectDescriptor getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public Set<ProjectDescriptor> getChildren() {
        return this.children;
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    void setPath(Path path) {
        this.path = path;
    }

    @Override
    public String getBuildFileName() {
        return this.buildFileName;
    }

    @Override
    public void setBuildFileName(String string) {
        this.buildFileName = string;
    }

    @Override
    public File getBuildFile() {
        return GFileUtils.canonicalise(new File(this.dir, this.buildFileName));
    }

    public IProjectDescriptorRegistry getProjectDescriptorRegistry() {
        return this.projectDescriptorRegistry;
    }

    public void setProjectDescriptorRegistry(IProjectDescriptorRegistry iProjectDescriptorRegistry) {
        this.projectDescriptorRegistry = iProjectDescriptorRegistry;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultProjectDescriptor defaultProjectDescriptor = (DefaultProjectDescriptor)object;
        return this.getPath().equals(defaultProjectDescriptor.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return this.getPath();
    }
}

