/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.StartParameter;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradlePropertiesLoader
implements IGradlePropertiesLoader {
    private static Logger logger = LoggerFactory.getLogger(DefaultGradlePropertiesLoader.class);
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private Map<String, String> overrideProperties = new HashMap<String, String>();
    private final StartParameter startParameter;

    public DefaultGradlePropertiesLoader(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public void loadProperties(File file) {
        this.loadProperties(file, this.startParameter, this.getAllSystemProperties(), this.getAllEnvProperties());
    }

    void loadProperties(File file, StartParameter startParameter, Map<String, String> map, Map<String, String> map2) {
        this.defaultProperties.clear();
        this.overrideProperties.clear();
        this.addGradleProperties(this.defaultProperties, new File(file, "gradle.properties"));
        this.addGradleProperties(this.overrideProperties, new File(startParameter.getGradleUserHomeDir(), "gradle.properties"));
        this.setSystemProperties(startParameter.getSystemPropertiesArgs());
        this.overrideProperties.putAll(this.getEnvProjectProperties(map2));
        this.overrideProperties.putAll(this.getSystemProjectProperties(map));
        this.overrideProperties.putAll(startParameter.getProjectProperties());
    }

    Map getAllSystemProperties() {
        return System.getProperties();
    }

    Map<String, String> getAllEnvProperties() {
        return System.getenv();
    }

    private void addGradleProperties(Map<String, String> map, File ... fileArray) {
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            Properties properties = GUtil.loadProperties(file);
            map.putAll(new HashMap<Object, Object>(properties));
        }
    }

    @Override
    public Map<String, String> mergeProperties(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.defaultProperties);
        hashMap.putAll(map);
        hashMap.putAll(this.overrideProperties);
        return hashMap;
    }

    private Map<String, String> getSystemProjectProperties(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("org.gradle.project.") || entry.getKey().length() <= "org.gradle.project.".length()) continue;
            hashMap.put(entry.getKey().substring("org.gradle.project.".length()), entry.getValue());
        }
        logger.debug("Found system project properties: {}", hashMap.keySet());
        return hashMap;
    }

    private Map<String, String> getEnvProjectProperties(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("ORG_GRADLE_PROJECT_") || entry.getKey().length() <= "ORG_GRADLE_PROJECT_".length()) continue;
            hashMap.put(entry.getKey().substring("ORG_GRADLE_PROJECT_".length()), entry.getValue());
        }
        logger.debug("Found env project properties: {}", hashMap.keySet());
        return hashMap;
    }

    private void setSystemProperties(Map<String, String> map) {
        System.getProperties().putAll(map);
        this.addSystemPropertiesFromGradleProperties(this.defaultProperties);
        this.addSystemPropertiesFromGradleProperties(this.overrideProperties);
    }

    private void addSystemPropertiesFromGradleProperties(Map<String, String> map) {
        for (String string : map.keySet()) {
            if (!string.startsWith("systemProp.")) continue;
            System.setProperty(string.substring("systemProp.".length()), map.get(string));
        }
    }
}

