/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Arrays;
import org.gradle.BuildAdapter;
import org.gradle.BuildLogger;
import org.gradle.BuildResult;
import org.gradle.GradleLauncher;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionLogger;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.Instantiator;
import org.gradle.api.internal.project.GlobalServicesRegistry;
import org.gradle.api.internal.project.TopLevelBuildServiceRegistry;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.cache.CacheRepository;
import org.gradle.cli.CommandLineConverter;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.BuildProgressLogger;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.BuildSourceBuilder;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.DefaultSettingsFinder;
import org.gradle.initialization.DependencyResolutionLogger;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.NestedBuildTracker;
import org.gradle.initialization.SettingsHandler;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.invocation.DefaultGradle;
import org.gradle.listener.ListenerManager;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.profile.ProfileEventAdapter;
import org.gradle.profile.ReportGeneratingProfileListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final ServiceRegistry sharedServices;
    private final NestedBuildTracker tracker;
    private CommandLineConverter<StartParameter> commandLineConverter;

    public DefaultGradleLauncherFactory(ServiceRegistry serviceRegistry) {
        this(new GlobalServicesRegistry(serviceRegistry));
    }

    public DefaultGradleLauncherFactory() {
        this(new GlobalServicesRegistry());
    }

    private DefaultGradleLauncherFactory(GlobalServicesRegistry globalServicesRegistry) {
        this.sharedServices = globalServicesRegistry;
        this.tracker = new NestedBuildTracker();
        ListenerManager listenerManager = (ListenerManager)this.sharedServices.get(ListenerManager.class);
        listenerManager.addListener(new BuildProgressLogger((ProgressLoggerFactory)this.sharedServices.get(ProgressLoggerFactory.class)));
        listenerManager.useLogger(new DependencyResolutionLogger((ProgressLoggerFactory)this.sharedServices.get(ProgressLoggerFactory.class)));
        GradleLauncher.injectCustomFactory(this);
    }

    public void addListener(Object object) {
        ((ListenerManager)this.sharedServices.get(ListenerManager.class)).addListener(object);
    }

    public void removeListener(Object object) {
        ((ListenerManager)this.sharedServices.get(ListenerManager.class)).removeListener(object);
    }

    @Override
    public StartParameter createStartParameter(String ... stringArray) {
        if (this.commandLineConverter == null) {
            this.commandLineConverter = (CommandLineConverter)this.sharedServices.get(CommandLineConverter.class);
        }
        return (StartParameter)this.commandLineConverter.convert(Arrays.asList(stringArray));
    }

    @Override
    public DefaultGradleLauncher newInstance(StartParameter startParameter) {
        DefaultBuildRequestMetaData defaultBuildRequestMetaData = this.tracker.getCurrentBuild() != null ? new DefaultBuildRequestMetaData((BuildClientMetaData)this.tracker.getCurrentBuild().getServices().get(BuildClientMetaData.class), System.currentTimeMillis()) : new DefaultBuildRequestMetaData(System.currentTimeMillis());
        return this.doNewInstance(startParameter, defaultBuildRequestMetaData);
    }

    @Override
    public DefaultGradleLauncher newInstance(StartParameter startParameter, BuildRequestMetaData buildRequestMetaData) {
        assert (this.tracker.getCurrentBuild() == null);
        return this.doNewInstance(startParameter, buildRequestMetaData);
    }

    private DefaultGradleLauncher doNewInstance(StartParameter startParameter, BuildRequestMetaData buildRequestMetaData) {
        TopLevelBuildServiceRegistry topLevelBuildServiceRegistry = new TopLevelBuildServiceRegistry(this.sharedServices, startParameter);
        topLevelBuildServiceRegistry.add(BuildRequestMetaData.class, buildRequestMetaData);
        topLevelBuildServiceRegistry.add(BuildClientMetaData.class, buildRequestMetaData.getClient());
        ListenerManager listenerManager = (ListenerManager)topLevelBuildServiceRegistry.get(ListenerManager.class);
        LoggingManagerInternal loggingManagerInternal = (LoggingManagerInternal)topLevelBuildServiceRegistry.newInstance(LoggingManagerInternal.class);
        loggingManagerInternal.setLevel(startParameter.getLogLevel());
        loggingManagerInternal.colorStdOutAndStdErr(startParameter.isColorOutput());
        loggingManagerInternal.addStandardOutputListener(listenerManager.getBroadcaster(StandardOutputListener.class));
        loggingManagerInternal.addStandardErrorListener(listenerManager.getBroadcaster(StandardOutputListener.class));
        listenerManager.useLogger(new TaskExecutionLogger((ProgressLoggerFactory)topLevelBuildServiceRegistry.get(ProgressLoggerFactory.class)));
        if (this.tracker.getCurrentBuild() == null) {
            listenerManager.useLogger(new BuildLogger(Logging.getLogger(BuildLogger.class), (StyledTextOutputFactory)topLevelBuildServiceRegistry.get(StyledTextOutputFactory.class), startParameter, buildRequestMetaData));
        }
        listenerManager.addListener(this.tracker);
        listenerManager.addListener(new BuildCleanupListener(topLevelBuildServiceRegistry));
        listenerManager.addListener(topLevelBuildServiceRegistry.get(ProfileEventAdapter.class));
        if (startParameter.isProfile()) {
            listenerManager.addListener(new ReportGeneratingProfileListener());
        }
        GradleInternal gradleInternal = ((Instantiator)topLevelBuildServiceRegistry.get(Instantiator.class)).newInstance(DefaultGradle.class, this.tracker.getCurrentBuild(), startParameter, topLevelBuildServiceRegistry);
        return new DefaultGradleLauncher(gradleInternal, (InitScriptHandler)topLevelBuildServiceRegistry.get(InitScriptHandler.class), new SettingsHandler(new DefaultSettingsFinder(new BuildLayoutFactory()), (SettingsProcessor)topLevelBuildServiceRegistry.get(SettingsProcessor.class), new BuildSourceBuilder(this, (ClassLoaderRegistry)topLevelBuildServiceRegistry.get(ClassLoaderRegistry.class), (CacheRepository)topLevelBuildServiceRegistry.get(CacheRepository.class))), (BuildLoader)topLevelBuildServiceRegistry.get(BuildLoader.class), (BuildConfigurer)topLevelBuildServiceRegistry.get(BuildConfigurer.class), gradleInternal.getBuildListenerBroadcaster(), (ExceptionAnalyser)topLevelBuildServiceRegistry.get(ExceptionAnalyser.class), loggingManagerInternal, listenerManager.getBroadcaster(ModelConfigurationListener.class), (BuildExecuter)gradleInternal.getServices().get(BuildExecuter.class));
    }

    public void setCommandLineConverter(CommandLineConverter<StartParameter> commandLineConverter) {
        this.commandLineConverter = commandLineConverter;
    }

    private static class BuildCleanupListener
    extends BuildAdapter {
        private final TopLevelBuildServiceRegistry services;

        private BuildCleanupListener(TopLevelBuildServiceRegistry topLevelBuildServiceRegistry) {
            this.services = topLevelBuildServiceRegistry;
        }

        public void buildFinished(BuildResult buildResult) {
            this.services.close();
        }
    }
}

