/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.GradleLauncher;
import org.gradle.StartParameter;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.SettingsHandler;
import org.gradle.logging.LoggingManagerInternal;

public class DefaultGradleLauncher
extends GradleLauncher {
    private final GradleInternal gradle;
    private final SettingsHandler settingsHandler;
    private final BuildLoader buildLoader;
    private final BuildConfigurer buildConfigurer;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildListener buildListener;
    private final InitScriptHandler initScriptHandler;
    private final LoggingManagerInternal loggingManager;
    private final ModelConfigurationListener modelConfigurationListener;
    private final BuildExecuter buildExecuter;

    public DefaultGradleLauncher(GradleInternal gradleInternal, InitScriptHandler initScriptHandler, SettingsHandler settingsHandler, BuildLoader buildLoader, BuildConfigurer buildConfigurer, BuildListener buildListener, ExceptionAnalyser exceptionAnalyser, LoggingManagerInternal loggingManagerInternal, ModelConfigurationListener modelConfigurationListener, BuildExecuter buildExecuter) {
        this.gradle = gradleInternal;
        this.initScriptHandler = initScriptHandler;
        this.settingsHandler = settingsHandler;
        this.buildLoader = buildLoader;
        this.buildConfigurer = buildConfigurer;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildListener = buildListener;
        this.loggingManager = loggingManagerInternal;
        this.modelConfigurationListener = modelConfigurationListener;
        this.buildExecuter = buildExecuter;
    }

    public GradleInternal getGradle() {
        return this.gradle;
    }

    public BuildResult run() {
        return this.doBuild(Stage.Build);
    }

    public BuildResult getBuildAnalysis() {
        return this.doBuild(Stage.Configure);
    }

    public BuildResult getBuildAndRunAnalysis() {
        return this.doBuild(Stage.PopulateTaskGraph);
    }

    private BuildResult doBuild(Stage stage) {
        this.loggingManager.start();
        this.buildListener.buildStarted(this.gradle);
        Throwable throwable = null;
        try {
            this.doBuildStages(stage);
        }
        catch (Throwable throwable2) {
            throwable = this.exceptionAnalyser.transform(throwable2);
        }
        BuildResult buildResult = new BuildResult(this.gradle, throwable);
        this.buildListener.buildFinished(buildResult);
        this.loggingManager.stop();
        return buildResult;
    }

    private void doBuildStages(Stage stage) {
        this.initScriptHandler.executeScripts(this.gradle);
        SettingsInternal settingsInternal = this.settingsHandler.findAndLoadSettings(this.gradle);
        this.buildListener.settingsEvaluated(settingsInternal);
        this.buildLoader.load(settingsInternal.getRootProject(), this.gradle);
        this.buildListener.projectsLoaded(this.gradle);
        this.buildConfigurer.configure(this.gradle);
        this.buildListener.projectsEvaluated(this.gradle);
        this.modelConfigurationListener.onConfigure(this.gradle);
        if (stage == Stage.Configure) {
            return;
        }
        this.buildExecuter.select(this.gradle);
        if (stage == Stage.PopulateTaskGraph) {
            return;
        }
        this.buildExecuter.execute();
        assert (stage == Stage.Build);
    }

    public void addListener(Object object) {
        this.gradle.addListener(object);
    }

    public void useLogger(Object object) {
        this.gradle.useLogger(object);
    }

    public void addStandardOutputListener(StandardOutputListener standardOutputListener) {
        this.loggingManager.addStandardOutputListener(standardOutputListener);
    }

    public void addStandardErrorListener(StandardOutputListener standardOutputListener) {
        this.loggingManager.addStandardErrorListener(standardOutputListener);
    }

    public StartParameter getStartParameter() {
        return this.gradle.getStartParameter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Stage {
        Configure,
        PopulateTaskGraph,
        Build;

    }
}

