/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.GradleScriptException;
import org.gradle.api.internal.Contextual;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.LocationAwareException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.listener.ListenerManager;
import org.gradle.listener.ListenerNotificationException;

public class DefaultExceptionAnalyser
implements ExceptionAnalyser,
ScriptExecutionListener {
    private final Map<String, ScriptSource> scripts = new HashMap<String, ScriptSource>();

    public DefaultExceptionAnalyser(ListenerManager listenerManager) {
        listenerManager.addListener(this);
    }

    public void beforeScript(Script script) {
        ScriptSource scriptSource = script.getScriptSource();
        this.scripts.put(scriptSource.getFileName(), scriptSource);
    }

    public void afterScript(Script script, Throwable throwable) {
    }

    public Throwable transform(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = this.findDeepest(throwable);
        if (throwable3 == null) {
            return throwable;
        }
        if (throwable3 instanceof LocationAwareException) {
            return throwable3;
        }
        ScriptSource scriptSource = null;
        Integer n = null;
        Throwable throwable4 = throwable3;
        if (throwable3 instanceof ScriptCompilationException) {
            throwable2 = (ScriptCompilationException)throwable3;
            scriptSource = ((ScriptCompilationException)throwable2).getScriptSource();
            n = ((ScriptCompilationException)throwable2).getLineNumber();
        }
        if (throwable3 instanceof ListenerNotificationException && throwable3.getCause() != null) {
            throwable4 = throwable3.getCause();
        }
        if (scriptSource == null) {
            block0: for (throwable2 = throwable3; throwable2 != null; throwable2 = throwable2.getCause()) {
                for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                    if (!this.scripts.containsKey(stackTraceElement.getFileName())) continue;
                    scriptSource = this.scripts.get(stackTraceElement.getFileName());
                    n = stackTraceElement.getLineNumber() >= 0 ? Integer.valueOf(stackTraceElement.getLineNumber()) : null;
                    continue block0;
                }
            }
        }
        return new LocationAwareException(throwable3, throwable4, scriptSource, n);
    }

    private Throwable findDeepest(Throwable throwable) {
        Throwable throwable2 = null;
        Throwable throwable3 = null;
        Throwable throwable4 = null;
        for (Throwable throwable5 = throwable; throwable5 != null; throwable5 = throwable5.getCause()) {
            if (throwable5 instanceof LocationAwareException) {
                throwable2 = throwable5;
                continue;
            }
            if (throwable5 instanceof GradleScriptException || throwable5 instanceof TaskExecutionException) {
                throwable3 = throwable5;
                continue;
            }
            if (throwable4 != null || throwable5.getClass().getAnnotation(Contextual.class) == null) continue;
            throwable4 = throwable5;
        }
        if (throwable2 != null) {
            return throwable2;
        }
        if (throwable3 != null) {
            return throwable3;
        }
        return throwable4;
    }
}

