/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.Map;
import org.gradle.CacheUsage;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.file.BaseDirFileResolver;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineConverter;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ProjectPropertiesCommandLineConverter;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeplatform.filesystem.FileSystems;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommandLineConverter
extends AbstractCommandLineConverter<StartParameter> {
    private static final String NO_SEARCH_UPWARDS = "u";
    private static final String PROJECT_DIR = "p";
    private static final String NO_PROJECT_DEPENDENCY_REBUILD = "a";
    private static final String BUILD_FILE = "b";
    public static final String INIT_SCRIPT = "I";
    private static final String SETTINGS_FILE = "c";
    public static final String GRADLE_USER_HOME = "g";
    private static final String CACHE = "C";
    private static final String DRY_RUN = "m";
    private static final String NO_OPT = "no-opt";
    private static final String RERUN_TASKS = "rerun-tasks";
    private static final String EXCLUDE_TASK = "x";
    private static final String PROFILE = "profile";
    private static final String CONTINUE = "continue";
    private static final String OFFLINE = "offline";
    private static final String REFRESH = "refresh";
    private static final String REFRESH_DEPENDENCIES = "refresh-dependencies";
    private static final String PROJECT_CACHE_DIR = "project-cache-dir";
    private static final String RECOMPILE_SCRIPTS = "recompile-scripts";
    private final CommandLineConverter<LoggingConfiguration> loggingConfigurationCommandLineConverter = new LoggingCommandLineConverter();
    private final SystemPropertiesCommandLineConverter systemPropertiesCommandLineConverter = new SystemPropertiesCommandLineConverter();
    private final ProjectPropertiesCommandLineConverter projectPropertiesCommandLineConverter = new ProjectPropertiesCommandLineConverter();

    public void configure(CommandLineParser commandLineParser) {
        this.loggingConfigurationCommandLineConverter.configure(commandLineParser);
        this.systemPropertiesCommandLineConverter.configure(commandLineParser);
        this.projectPropertiesCommandLineConverter.configure(commandLineParser);
        commandLineParser.allowMixedSubcommandsAndOptions();
        commandLineParser.option(new String[]{NO_SEARCH_UPWARDS, "no-search-upward"}).hasDescription(String.format("Don't search in parent folders for a %s file.", "settings.gradle"));
        commandLineParser.option(new String[]{CACHE, "cache"}).hasArgument().hasDescription("Specifies how compiled build scripts should be cached. Possible values are: 'rebuild' and 'on'. Default value is 'on'").deprecated("Use '--rerun-tasks' or '--recompile-scripts' instead");
        commandLineParser.option(new String[]{PROJECT_CACHE_DIR}).hasArgument().hasDescription("Specifies the project-specific cache directory. Defaults to .gradle in the root project directory.");
        commandLineParser.option(new String[]{DRY_RUN, "dry-run"}).hasDescription("Runs the builds with all task actions disabled.");
        commandLineParser.option(new String[]{PROJECT_DIR, "project-dir"}).hasArgument().hasDescription("Specifies the start directory for Gradle. Defaults to current directory.");
        commandLineParser.option(new String[]{GRADLE_USER_HOME, "gradle-user-home"}).hasArgument().hasDescription("Specifies the gradle user home directory.");
        commandLineParser.option(new String[]{INIT_SCRIPT, "init-script"}).hasArguments().hasDescription("Specifies an initialization script.");
        commandLineParser.option(new String[]{SETTINGS_FILE, "settings-file"}).hasArgument().hasDescription("Specifies the settings file.");
        commandLineParser.option(new String[]{BUILD_FILE, "build-file"}).hasArgument().hasDescription("Specifies the build file.");
        commandLineParser.option(new String[]{NO_PROJECT_DEPENDENCY_REBUILD, "no-rebuild"}).hasDescription("Do not rebuild project dependencies.");
        commandLineParser.option(new String[]{NO_OPT}).hasDescription("Ignore any task optimization.").deprecated("Use '--rerun-tasks' instead");
        commandLineParser.option(new String[]{RERUN_TASKS}).hasDescription("Ignore previously cached task results.");
        commandLineParser.option(new String[]{RECOMPILE_SCRIPTS}).hasDescription("Force build script recompiling.");
        commandLineParser.option(new String[]{EXCLUDE_TASK, "exclude-task"}).hasArguments().hasDescription("Specify a task to be excluded from execution.");
        commandLineParser.option(new String[]{PROFILE}).hasDescription("Profiles build execution time and generates a report in the <build_dir>/reports/profile directory.");
        commandLineParser.option(new String[]{CONTINUE}).hasDescription("Continues task execution after a task failure.").experimental();
        commandLineParser.option(new String[]{OFFLINE}).hasDescription("The build should operate without accessing network resources.");
        commandLineParser.option(new String[]{REFRESH}).hasArguments().hasDescription("Refresh the state of resources of the type(s) specified. Currently only 'dependencies' is supported.").deprecated("Use '--refresh-dependencies' instead.");
        commandLineParser.option(new String[]{REFRESH_DEPENDENCIES}).hasDescription("Refresh the state of dependencies.");
    }

    protected StartParameter newInstance() {
        return new StartParameter();
    }

    public StartParameter convert(final ParsedCommandLine parsedCommandLine, final StartParameter startParameter) throws CommandLineArgumentException {
        Object object;
        this.loggingConfigurationCommandLineConverter.convert(parsedCommandLine, (Object)startParameter);
        BaseDirFileResolver baseDirFileResolver = new BaseDirFileResolver(FileSystems.getDefault(), startParameter.getCurrentDir());
        Map map = (Map)this.systemPropertiesCommandLineConverter.convert(parsedCommandLine);
        this.convertCommandLineSystemProperties(map, startParameter, baseDirFileResolver);
        Map map2 = (Map)this.projectPropertiesCommandLineConverter.convert(parsedCommandLine);
        startParameter.getProjectProperties().putAll(map2);
        if (parsedCommandLine.hasOption(NO_SEARCH_UPWARDS)) {
            startParameter.setSearchUpwards(false);
        }
        if (parsedCommandLine.hasOption(PROJECT_DIR)) {
            startParameter.setProjectDir(baseDirFileResolver.resolve(parsedCommandLine.option(PROJECT_DIR).getValue()));
        }
        if (parsedCommandLine.hasOption(GRADLE_USER_HOME)) {
            startParameter.setGradleUserHomeDir(baseDirFileResolver.resolve(parsedCommandLine.option(GRADLE_USER_HOME).getValue()));
        }
        if (parsedCommandLine.hasOption(BUILD_FILE)) {
            startParameter.setBuildFile(baseDirFileResolver.resolve(parsedCommandLine.option(BUILD_FILE).getValue()));
        }
        if (parsedCommandLine.hasOption(SETTINGS_FILE)) {
            startParameter.setSettingsFile(baseDirFileResolver.resolve(parsedCommandLine.option(SETTINGS_FILE).getValue()));
        }
        for (Object object2 : parsedCommandLine.option(INIT_SCRIPT).getValues()) {
            startParameter.addInitScript(baseDirFileResolver.resolve(object2));
        }
        if (parsedCommandLine.hasOption(CACHE)) {
            try {
                object = DeprecationLogger.whileDisabled(new Factory<CacheUsage>(){

                    public CacheUsage create() {
                        return CacheUsage.fromString(parsedCommandLine.option(DefaultCommandLineConverter.CACHE).getValue());
                    }
                });
                DeprecationLogger.whileDisabled(new Factory<Void>(){

                    public Void create() {
                        startParameter.setCacheUsage(object);
                        return null;
                    }
                });
            }
            catch (InvalidUserDataException invalidUserDataException) {
                throw new CommandLineArgumentException(invalidUserDataException.getMessage());
            }
        }
        if (parsedCommandLine.hasOption(PROJECT_CACHE_DIR)) {
            startParameter.setProjectCacheDir(baseDirFileResolver.resolve(parsedCommandLine.option(PROJECT_CACHE_DIR).getValue()));
        }
        if (parsedCommandLine.hasOption(NO_PROJECT_DEPENDENCY_REBUILD)) {
            startParameter.setBuildProjectDependencies(false);
        }
        if (!parsedCommandLine.getExtraArguments().isEmpty()) {
            startParameter.setTaskNames(parsedCommandLine.getExtraArguments());
        }
        if (parsedCommandLine.hasOption(DRY_RUN)) {
            startParameter.setDryRun(true);
        }
        if (parsedCommandLine.hasOption(NO_OPT)) {
            startParameter.setRerunTasks(true);
        }
        if (parsedCommandLine.hasOption(RERUN_TASKS)) {
            startParameter.setRerunTasks(true);
        }
        if (parsedCommandLine.hasOption(RECOMPILE_SCRIPTS)) {
            startParameter.setRecompileScripts(true);
        }
        if (parsedCommandLine.hasOption(EXCLUDE_TASK)) {
            startParameter.setExcludedTaskNames(parsedCommandLine.option(EXCLUDE_TASK).getValues());
        }
        if (parsedCommandLine.hasOption(PROFILE)) {
            startParameter.setProfile(true);
        }
        if (parsedCommandLine.hasOption(CONTINUE)) {
            startParameter.setContinueOnFailure(true);
        }
        if (parsedCommandLine.hasOption(OFFLINE)) {
            startParameter.setOffline(true);
        }
        if (parsedCommandLine.hasOption(REFRESH)) {
            Object object2;
            object = parsedCommandLine.option(REFRESH).getValues();
            object2 = object.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                if (string.equalsIgnoreCase("dependencies")) {
                    startParameter.setRefreshDependencies(true);
                    continue;
                }
                throw new CommandLineArgumentException(String.format("Unknown refresh option '%s' specified.", string));
            }
        }
        if (parsedCommandLine.hasOption(REFRESH_DEPENDENCIES)) {
            startParameter.setRefreshDependencies(true);
        }
        return startParameter;
    }

    void convertCommandLineSystemProperties(Map<String, String> map, StartParameter startParameter, FileResolver fileResolver) {
        startParameter.getSystemPropertiesArgs().putAll(map);
        String string = "gradle.user.home";
        if (map.containsKey(string)) {
            startParameter.setGradleUserHomeDir(fileResolver.resolve(map.get(string)));
        }
    }
}

