/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Collections;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.jvm.Jvm;
import org.gradle.util.ClassLoaderFactory;
import org.gradle.util.ClassPath;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.FilteringClassLoader;
import org.gradle.util.GFileUtils;
import org.gradle.util.MultiParentClassLoader;
import org.gradle.util.MutableURLClassLoader;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry {
    private final FilteringClassLoader rootClassLoader;
    private final ClassLoader coreImplClassLoader;
    private final ClassLoader pluginsClassLoader;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory) {
        ClassLoader classLoader;
        File file = Jvm.current().getToolsJar();
        if (file != null) {
            classLoader = ClassLoader.getSystemClassLoader().getParent();
            ClasspathUtil.addUrl((URLClassLoader)classLoader, GFileUtils.toURLs(Collections.singleton(file)));
        }
        classLoader = this.getClass().getClassLoader();
        ClassPath classPath = classPathRegistry.getClassPath("GRADLE_CORE_IMPL");
        this.coreImplClassLoader = new MutableURLClassLoader(classLoader, classPath);
        ClassPath classPath2 = classPathRegistry.getClassPath("GRADLE_PLUGINS");
        MultiParentClassLoader multiParentClassLoader = new MultiParentClassLoader(classLoader, this.coreImplClassLoader);
        this.pluginsClassLoader = new MutableURLClassLoader((ClassLoader)multiParentClassLoader, classPath2);
        this.rootClassLoader = classLoaderFactory.createFilteringClassLoader(this.pluginsClassLoader);
        this.rootClassLoader.allowPackage("org.gradle");
        this.rootClassLoader.allowResources("META-INF/gradle-plugins");
        this.rootClassLoader.allowPackage("org.apache.tools.ant");
        this.rootClassLoader.allowPackage("groovy");
        this.rootClassLoader.allowPackage("org.codehaus.groovy");
        this.rootClassLoader.allowPackage("groovyjarjarantlr");
        this.rootClassLoader.allowPackage("org.apache.ivy");
        this.rootClassLoader.allowPackage("org.slf4j");
        this.rootClassLoader.allowPackage("org.apache.commons.logging");
        this.rootClassLoader.allowPackage("org.apache.log4j");
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public ClassLoader getCoreImplClassLoader() {
        return this.coreImplClassLoader;
    }

    public ClassLoader getPluginsClassLoader() {
        return this.pluginsClassLoader;
    }

    public MultiParentClassLoader createScriptClassLoader() {
        return new MultiParentClassLoader(new ClassLoader[]{this.rootClassLoader});
    }
}

