/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.BuildAdapter;
import org.gradle.GradleLauncher;
import org.gradle.StartParameter;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.plugins.EmbeddableJavaProject;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentStateCache;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.util.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    private final GradleLauncherFactory gradleLauncherFactory;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final CacheRepository cacheRepository;
    private static final String DEFAULT_BUILD_SOURCE_SCRIPT_RESOURCE = "defaultBuildSourceScript.txt";

    public BuildSourceBuilder(GradleLauncherFactory gradleLauncherFactory, ClassLoaderRegistry classLoaderRegistry, CacheRepository cacheRepository) {
        this.gradleLauncherFactory = gradleLauncherFactory;
        this.classLoaderRegistry = classLoaderRegistry;
        this.cacheRepository = cacheRepository;
    }

    public URLClassLoader buildAndCreateClassLoader(StartParameter startParameter) {
        Set<File> set = this.createBuildSourceClasspath(startParameter);
        Iterator<File> iterator = set.iterator();
        URL[] uRLArray = new URL[set.size()];
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                uRLArray[i] = iterator.next().toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new UncheckedIOException(malformedURLException);
            }
        }
        return new URLClassLoader(uRLArray, this.classLoaderRegistry.getRootClassLoader());
    }

    public Set<File> createBuildSourceClasspath(StartParameter startParameter) {
        assert (startParameter.getCurrentDir() != null && startParameter.getBuildFile() == null);
        LOGGER.debug("Starting to build the build sources.");
        if (!startParameter.getCurrentDir().isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return new HashSet<File>();
        }
        LOGGER.info("================================================ Start building buildSrc");
        StartParameter startParameter2 = startParameter.newInstance();
        startParameter2.setProjectProperties(startParameter.getProjectProperties());
        startParameter2.setSearchUpwards(false);
        startParameter2.setProfile(startParameter.isProfile());
        PersistentStateCache persistentStateCache = (PersistentStateCache)this.cacheRepository.stateCache(Boolean.class, "buildSrc").forObject(startParameter.getCurrentDir()).withVersionStrategy(CacheBuilder.VersionStrategy.SharedCacheInvalidateOnVersionChange).open();
        boolean bl = persistentStateCache.get() == null;
        GradleLauncher gradleLauncher = this.gradleLauncherFactory.newInstance(startParameter2);
        BuildSrcBuildListener buildSrcBuildListener = new BuildSrcBuildListener(bl);
        gradleLauncher.addListener(buildSrcBuildListener);
        gradleLauncher.run().rethrowFailure();
        persistentStateCache.set(true);
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        linkedHashSet.addAll(buildSrcBuildListener.getRuntimeClasspath());
        LOGGER.debug("Gradle source classpath is: {}", linkedHashSet);
        LOGGER.info("================================================ Finished building buildSrc");
        return linkedHashSet;
    }

    static URL getDefaultScript() {
        return BuildSourceBuilder.class.getResource(DEFAULT_BUILD_SOURCE_SCRIPT_RESOURCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildSrcBuildListener
    extends BuildAdapter {
        private EmbeddableJavaProject projectInfo;
        private Set<File> classpath;
        private final boolean rebuild;

        public BuildSrcBuildListener(boolean bl) {
            this.rebuild = bl;
        }

        @Override
        public void projectsLoaded(Gradle gradle) {
            gradle.getRootProject().apply(WrapUtil.toMap("from", BuildSourceBuilder.getDefaultScript()));
        }

        @Override
        public void projectsEvaluated(Gradle gradle) {
            this.projectInfo = gradle.getRootProject().getConvention().getPlugin(EmbeddableJavaProject.class);
            gradle.getStartParameter().setTaskNames(this.rebuild ? this.projectInfo.getRebuildTasks() : this.projectInfo.getBuildTasks());
            this.classpath = this.projectInfo.getRuntimeClasspath().getFiles();
        }

        public Collection<File> getRuntimeClasspath() {
            return this.classpath;
        }
    }
}

