/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;

class BuildProgressLogger
extends BuildAdapter
implements TaskExecutionGraphListener {
    private ProgressLogger progressLogger;
    private final ProgressLoggerFactory progressLoggerFactory;
    private Gradle gradle;

    public BuildProgressLogger(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    public void buildStarted(Gradle gradle) {
        if (gradle.getParent() == null) {
            this.progressLogger = this.progressLoggerFactory.newOperation(BuildProgressLogger.class);
            this.progressLogger.setDescription("Configure projects");
            this.progressLogger.setShortDescription("Loading");
            this.progressLogger.started();
            this.gradle = gradle;
        }
    }

    public void graphPopulated(TaskExecutionGraph taskExecutionGraph) {
        if (taskExecutionGraph == this.gradle.getTaskGraph()) {
            this.progressLogger.completed();
            this.progressLogger = this.progressLoggerFactory.newOperation(BuildProgressLogger.class);
            this.progressLogger.setDescription("Execute tasks");
            this.progressLogger.setShortDescription("Building");
            this.progressLogger.started();
        }
    }

    public void buildFinished(BuildResult buildResult) {
        if (buildResult.getGradle() == this.gradle) {
            this.progressLogger.completed();
            this.progressLogger = null;
            this.gradle = null;
        }
    }
}

