/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.IProjectRegistry;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.IProjectDescriptorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSettings
implements SettingsInternal {
    public static final String DEFAULT_BUILD_SRC_DIR = "buildSrc";
    private ScriptSource settingsScript;
    private StartParameter startParameter;
    private URLClassLoader classloader;
    private File settingsDir;
    private DefaultProjectDescriptor rootProjectDescriptor;
    private ExtensibleDynamicObject dynamicObject;
    private GradleInternal gradle;
    private IProjectDescriptorRegistry projectDescriptorRegistry;

    protected BaseSettings() {
    }

    public BaseSettings(GradleInternal gradleInternal, IProjectDescriptorRegistry iProjectDescriptorRegistry, URLClassLoader uRLClassLoader, File file, ScriptSource scriptSource, StartParameter startParameter) {
        this.gradle = gradleInternal;
        this.projectDescriptorRegistry = iProjectDescriptorRegistry;
        this.settingsDir = file;
        this.settingsScript = scriptSource;
        this.startParameter = startParameter;
        this.classloader = uRLClassLoader;
        this.rootProjectDescriptor = this.createProjectDescriptor(null, file.getName(), file);
        this.dynamicObject = new ExtensibleDynamicObject(this);
    }

    public String toString() {
        return String.format("settings '%s'", this.rootProjectDescriptor.getName());
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public Settings getSettings() {
        return this;
    }

    public DefaultProjectDescriptor createProjectDescriptor(DefaultProjectDescriptor defaultProjectDescriptor, String string, File file) {
        return new DefaultProjectDescriptor(defaultProjectDescriptor, string, file, this.projectDescriptorRegistry);
    }

    @Override
    public DefaultProjectDescriptor findProject(String string) {
        return (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(string);
    }

    @Override
    public DefaultProjectDescriptor findProject(File file) {
        return (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(file);
    }

    @Override
    public DefaultProjectDescriptor project(String string) {
        DefaultProjectDescriptor defaultProjectDescriptor = (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(string);
        if (defaultProjectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", string));
        }
        return defaultProjectDescriptor;
    }

    @Override
    public DefaultProjectDescriptor project(File file) {
        DefaultProjectDescriptor defaultProjectDescriptor = (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(file);
        if (defaultProjectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", file));
        }
        return defaultProjectDescriptor;
    }

    @Override
    public void include(String[] stringArray) {
        for (String string : stringArray) {
            String string2 = "";
            String[] stringArray2 = this.removeTrailingColon(string).split(":");
            DefaultProjectDescriptor defaultProjectDescriptor = this.rootProjectDescriptor;
            for (String string3 : stringArray2) {
                DefaultProjectDescriptor defaultProjectDescriptor2 = (DefaultProjectDescriptor)this.projectDescriptorRegistry.getProject(string2 = string2 + ":" + string3);
                defaultProjectDescriptor = defaultProjectDescriptor2 == null ? this.createProjectDescriptor(defaultProjectDescriptor, string3, new File(defaultProjectDescriptor.getProjectDir(), string3)) : defaultProjectDescriptor2;
            }
        }
    }

    @Override
    public void includeFlat(String[] stringArray) {
        for (String string : stringArray) {
            this.createProjectDescriptor(this.rootProjectDescriptor, string, new File(this.rootProjectDescriptor.getProjectDir().getParentFile(), string));
        }
    }

    private String removeTrailingColon(String string) {
        if (string.startsWith(":")) {
            return string.substring(1);
        }
        return string;
    }

    @Override
    public URLClassLoader getClassLoader() {
        return this.classloader;
    }

    @Override
    public ProjectDescriptor getRootProject() {
        return this.rootProjectDescriptor;
    }

    public void setRootProjectDescriptor(DefaultProjectDescriptor defaultProjectDescriptor) {
        this.rootProjectDescriptor = defaultProjectDescriptor;
    }

    @Override
    public File getRootDir() {
        return this.rootProjectDescriptor.getProjectDir();
    }

    @Override
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public File getSettingsDir() {
        return this.settingsDir;
    }

    public void setSettingsDir(File file) {
        this.settingsDir = file;
    }

    @Override
    public ScriptSource getSettingsScript() {
        return this.settingsScript;
    }

    public void setSettingsScript(ScriptSource scriptSource) {
        this.settingsScript = scriptSource;
    }

    public IProjectDescriptorRegistry getProjectDescriptorRegistry() {
        return this.projectDescriptorRegistry;
    }

    public void setProjectDescriptorRegistry(IProjectDescriptorRegistry iProjectDescriptorRegistry) {
        this.projectDescriptorRegistry = iProjectDescriptorRegistry;
    }

    public void addDynamicProperties(Map<String, ?> map) {
        this.dynamicObject.addProperties(map);
    }

    protected DynamicObject getDynamicObject() {
        return this.dynamicObject;
    }

    @Override
    public IProjectRegistry<DefaultProjectDescriptor> getProjectRegistry() {
        return this.projectDescriptorRegistry;
    }
}

