/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.IProjectRegistry;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.initialization.ProjectSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectSpec
implements ProjectSpec {
    @Override
    public boolean containsProject(IProjectRegistry<?> iProjectRegistry) {
        this.checkPreconditions(iProjectRegistry);
        for (ProjectIdentifier projectIdentifier : iProjectRegistry.getAllProjects()) {
            if (!this.select(projectIdentifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends ProjectIdentifier> T selectProject(IProjectRegistry<? extends T> iProjectRegistry) {
        this.checkPreconditions(iProjectRegistry);
        ArrayList<ProjectIdentifier> arrayList = new ArrayList<ProjectIdentifier>();
        for (ProjectIdentifier projectIdentifier : iProjectRegistry.getAllProjects()) {
            if (!this.select(projectIdentifier)) continue;
            arrayList.add(projectIdentifier);
        }
        if (arrayList.isEmpty()) {
            throw new InvalidUserDataException(this.formatNoMatchesMessage());
        }
        if (arrayList.size() != 1) {
            throw new InvalidUserDataException(this.formatMultipleMatchesMessage(arrayList));
        }
        return (T)((ProjectIdentifier)arrayList.get(0));
    }

    protected void checkPreconditions(IProjectRegistry<?> iProjectRegistry) {
    }

    protected abstract String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> var1);

    protected abstract String formatNoMatchesMessage();

    protected abstract boolean select(ProjectIdentifier var1);
}

