/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import java.io.File;
import java.util.HashMap;
import org.gradle.api.Action;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.util.hash.HashUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheBackedScriptClassCompiler
implements ScriptClassCompiler {
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final CacheRepository cacheRepository;
    private final CacheValidator validator;

    public FileCacheBackedScriptClassCompiler(CacheRepository cacheRepository, CacheValidator cacheValidator, ScriptCompilationHandler scriptCompilationHandler) {
        this.cacheRepository = cacheRepository;
        this.validator = cacheValidator;
        this.scriptCompilationHandler = scriptCompilationHandler;
    }

    @Override
    public <T extends Script> Class<? extends T> compile(ScriptSource scriptSource, ClassLoader classLoader, Transformer transformer, Class<T> clazz) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("source.filename", scriptSource.getFileName());
        hashMap.put("source.hash", HashUtil.createCompactMD5(scriptSource.getResource().getText()));
        String string = String.format("scripts/%s/%s/%s", scriptSource.getClassName(), clazz.getSimpleName(), transformer.getId());
        PersistentCache persistentCache = (PersistentCache)this.cacheRepository.cache(string).withProperties(hashMap).withValidator(this.validator).withDisplayName(String.format("%s class cache for %s", transformer.getId(), scriptSource.getDisplayName())).withInitializer(new CacheInitializer(scriptSource, classLoader, transformer, clazz)).open();
        File file = this.classesDir(persistentCache);
        return this.scriptCompilationHandler.loadFromDir(scriptSource, classLoader, file, clazz);
    }

    private File classesDir(PersistentCache persistentCache) {
        return new File(persistentCache.getBaseDir(), "classes");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheInitializer
    implements Action<PersistentCache> {
        private final Class<? extends Script> scriptBaseClass;
        private final ClassLoader classLoader;
        private final Transformer transformer;
        private final ScriptSource source;

        private CacheInitializer(ScriptSource scriptSource, ClassLoader classLoader, Transformer transformer, Class<? extends Script> clazz) {
            this.source = scriptSource;
            this.classLoader = classLoader;
            this.transformer = transformer;
            this.scriptBaseClass = clazz;
        }

        @Override
        public void execute(PersistentCache persistentCache) {
            File file = FileCacheBackedScriptClassCompiler.this.classesDir(persistentCache);
            FileCacheBackedScriptClassCompiler.this.scriptCompilationHandler.compileToDir(this.source, this.classLoader, file, this.transformer, this.scriptBaseClass);
        }
    }
}

