/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.gradle.api.GradleScriptException;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptExecutionListener;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.internal.ScriptRunnerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptRunnerFactory
implements ScriptRunnerFactory {
    private final ScriptExecutionListener listener;

    public DefaultScriptRunnerFactory(ScriptExecutionListener scriptExecutionListener) {
        this.listener = scriptExecutionListener;
    }

    @Override
    public <T extends Script> ScriptRunner<T> create(T t) {
        return new ScriptRunnerImpl(this, t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptRunnerImpl<T extends Script>
    implements ScriptRunner<T> {
        private final T script;
        final /* synthetic */ DefaultScriptRunnerFactory this$0;

        public ScriptRunnerImpl(T t) {
            this.this$0 = var1_1;
            this.script = t;
        }

        @Override
        public T getScript() {
            return this.script;
        }

        @Override
        public void run() throws GradleScriptException {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.this$0.listener.beforeScript((Script)((Object)this.script));
            GradleScriptException gradleScriptException = null;
            Thread.currentThread().setContextClassLoader(((Script)((Object)this.script)).getContextClassloader());
            ((Script)((Object)this.script)).getStandardOutputCapture().start();
            try {
                this.script.run();
            }
            catch (Throwable throwable) {
                gradleScriptException = new GradleScriptException(String.format("A problem occurred evaluating %s.", this.script), throwable);
            }
            ((Script)((Object)this.script)).getStandardOutputCapture().stop();
            Thread.currentThread().setContextClassLoader(classLoader);
            this.this$0.listener.afterScript((Script)((Object)this.script), gradleScriptException);
            if (gradleScriptException != null) {
                throw gradleScriptException;
            }
        }
    }
}

