/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.gradle.api.GradleException;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.EmptyScriptGenerator;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.internal.UncheckedException;
import org.gradle.util.Clock;
import org.gradle.util.GFileUtils;
import org.gradle.util.WrapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptCompilationHandler
implements ScriptCompilationHandler {
    private Logger logger = LoggerFactory.getLogger(DefaultScriptCompilationHandler.class);
    private static final String EMPTY_SCRIPT_MARKER_FILE_NAME = "emptyScript.txt";
    private final EmptyScriptGenerator emptyScriptGenerator;

    public DefaultScriptCompilationHandler(EmptyScriptGenerator emptyScriptGenerator) {
        this.emptyScriptGenerator = emptyScriptGenerator;
    }

    @Override
    public void compileToDir(ScriptSource scriptSource, ClassLoader classLoader, File file, Transformer transformer, Class<? extends Script> clazz) {
        Clock clock = new Clock();
        GFileUtils.deleteDirectory(file);
        file.mkdirs();
        CompilerConfiguration compilerConfiguration = this.createBaseCompilerConfiguration(clazz);
        compilerConfiguration.setTargetDirectory(file);
        try {
            this.compileScript(scriptSource, classLoader, compilerConfiguration, file, transformer);
        }
        catch (GradleException gradleException) {
            GFileUtils.deleteDirectory(file);
            throw gradleException;
        }
        this.logger.debug("Timing: Writing script to cache at {} took: {}", (Object)file.getAbsolutePath(), (Object)clock.getTime());
    }

    private void compileScript(final ScriptSource scriptSource, ClassLoader classLoader, CompilerConfiguration compilerConfiguration, File file, final Transformer transformer) {
        this.logger.info("Compiling {} using {}.", (Object)scriptSource.getDisplayName(), (Object)(transformer != null ? transformer.getClass().getSimpleName() : "no transformer"));
        final EmptyScriptDetector emptyScriptDetector = new EmptyScriptDetector();
        final PackageStatementDetector packageStatementDetector = new PackageStatementDetector();
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader, compilerConfiguration, false){

            protected CompilationUnit createCompilationUnit(CompilerConfiguration compilerConfiguration, CodeSource codeSource) {
                CompilationUnit compilationUnit = new CompilationUnit(compilerConfiguration, codeSource, this){

                    protected ClassVisitor createClassVisitor() {
                        return new ClassWriter(1){

                            public void visitSource(String string, String string2) {
                                super.visitSource(scriptSource.getFileName(), string2);
                            }
                        };
                    }
                };
                if (transformer != null) {
                    transformer.register(compilationUnit);
                }
                compilationUnit.addPhaseOperation((CompilationUnit.SourceUnitOperation)packageStatementDetector, 5);
                compilationUnit.addPhaseOperation((CompilationUnit.SourceUnitOperation)emptyScriptDetector, 5);
                return compilationUnit;
            }
        };
        String string = scriptSource.getResource().getText();
        String string2 = scriptSource.getClassName();
        GroovyCodeSource groovyCodeSource = new GroovyCodeSource(string == null ? "" : string, string2, "/groovy/script");
        try {
            groovyClassLoader.parseClass(groovyCodeSource, false);
        }
        catch (MultipleCompilationErrorsException multipleCompilationErrorsException) {
            this.wrapCompilationFailure(scriptSource, multipleCompilationErrorsException);
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new GradleException(String.format("Could not compile %s.", scriptSource.getDisplayName()), compilationFailedException);
        }
        if (packageStatementDetector.hasPackageStatement) {
            throw new UnsupportedOperationException(String.format("%s should not contain a package statement.", StringUtils.capitalize((String)scriptSource.getDisplayName())));
        }
        if (emptyScriptDetector.isEmptyScript()) {
            GFileUtils.touch(new File(file, EMPTY_SCRIPT_MARKER_FILE_NAME));
        }
    }

    private void wrapCompilationFailure(ScriptSource scriptSource, MultipleCompilationErrorsException multipleCompilationErrorsException) {
        Object e2;
        for (Object e2 : multipleCompilationErrorsException.getErrorCollector().getErrors()) {
            if (!(e2 instanceof SyntaxErrorMessage)) continue;
            try {
                SyntaxErrorMessage syntaxErrorMessage = (SyntaxErrorMessage)e2;
                Field field = SyntaxErrorMessage.class.getDeclaredField("source");
                field.setAccessible(true);
                SourceUnit sourceUnit = (SourceUnit)field.get(syntaxErrorMessage);
                Field field2 = SourceUnit.class.getDeclaredField("name");
                field2.setAccessible(true);
                field2.set(sourceUnit, scriptSource.getDisplayName());
            }
            catch (Exception exception) {
                throw UncheckedException.throwAsUncheckedException((Throwable)exception);
            }
        }
        SyntaxException syntaxException = multipleCompilationErrorsException.getErrorCollector().getSyntaxError(0);
        e2 = syntaxException == null ? null : Integer.valueOf(syntaxException.getLine());
        throw new ScriptCompilationException(String.format("Could not compile %s.", scriptSource.getDisplayName()), (Throwable)multipleCompilationErrorsException, scriptSource, (Integer)e2);
    }

    private CompilerConfiguration createBaseCompilerConfiguration(Class<? extends Script> clazz) {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setScriptBaseClass(clazz.getName());
        return compilerConfiguration;
    }

    @Override
    public <T extends Script> Class<? extends T> loadFromDir(ScriptSource scriptSource, ClassLoader classLoader, File file, Class<T> clazz) {
        if (new File(file, EMPTY_SCRIPT_MARKER_FILE_NAME).isFile()) {
            return this.emptyScriptGenerator.generate(clazz);
        }
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(WrapUtil.toArray(file.toURI().toURL()), classLoader);
            return uRLClassLoader.loadClass(scriptSource.getClassName()).asSubclass(clazz);
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not load compiled classes for %s from cache.", scriptSource.getDisplayName()), exception);
        }
    }

    private static class EmptyScriptDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean emptyScript;

        private EmptyScriptDetector() {
        }

        public void call(SourceUnit sourceUnit) throws CompilationFailedException {
            this.emptyScript = this.isEmpty(sourceUnit);
        }

        private boolean isEmpty(SourceUnit sourceUnit) {
            ConstantExpression constantExpression;
            ReturnStatement returnStatement;
            if (!sourceUnit.getAST().getMethods().isEmpty()) {
                return false;
            }
            List list = sourceUnit.getAST().getStatementBlock().getStatements();
            if (list.size() > 1) {
                return false;
            }
            if (list.isEmpty()) {
                return true;
            }
            Statement statement = (Statement)list.get(0);
            return statement instanceof ReturnStatement && (returnStatement = (ReturnStatement)statement).getExpression() instanceof ConstantExpression && (constantExpression = (ConstantExpression)returnStatement.getExpression()).getValue() == null;
        }

        public boolean isEmptyScript() {
            return this.emptyScript;
        }
    }

    private static class PackageStatementDetector
    extends CompilationUnit.SourceUnitOperation {
        private boolean hasPackageStatement;

        private PackageStatementDetector() {
        }

        public void call(SourceUnit sourceUnit) throws CompilationFailedException {
            this.hasPackageStatement = sourceUnit.getAST().getPackageName() != null;
        }
    }
}

