/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import groovy.lang.Script;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingScriptClassCompiler
implements ScriptClassCompiler {
    private final Map<Collection<Object>, Class<?>> cachedClasses = new HashMap();
    private final ScriptClassCompiler scriptClassCompiler;

    public CachingScriptClassCompiler(ScriptClassCompiler scriptClassCompiler) {
        this.scriptClassCompiler = scriptClassCompiler;
    }

    @Override
    public <T extends Script> Class<? extends T> compile(ScriptSource scriptSource, ClassLoader classLoader, Transformer transformer, Class<T> clazz) {
        List<Object> list = Arrays.asList(scriptSource.getClassName(), classLoader, transformer.getId(), clazz.getName());
        Class<Object> clazz2 = this.cachedClasses.get(list);
        if (clazz2 == null) {
            clazz2 = this.scriptClassCompiler.compile(scriptSource, classLoader, transformer, clazz);
            this.cachedClasses.put(list, clazz2);
        }
        return clazz2.asSubclass(clazz);
    }
}

