/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import java.io.File;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.resource.Resource;
import org.gradle.api.internal.resource.UriResource;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.hash.HashUtil;

public class UriScriptSource
implements ScriptSource {
    private final Resource resource;
    private String className;

    public UriScriptSource(String string, File file) {
        this.resource = new UriResource(string, file);
    }

    public UriScriptSource(String string, URI uRI) {
        this.resource = new UriResource(string, uRI);
    }

    public String getClassName() {
        if (this.className == null) {
            URI uRI = this.resource.getURI();
            String string = StringUtils.substringBeforeLast((String)StringUtils.substringAfterLast((String)uRI.toString(), (String)"/"), (String)".");
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append('_');
            }
            if (!Character.isJavaIdentifierStart(stringBuilder.charAt(0))) {
                stringBuilder.insert(0, '_');
            }
            stringBuilder.setLength(Math.min(stringBuilder.length(), 30));
            stringBuilder.append('_');
            String string2 = uRI.toString();
            stringBuilder.append(HashUtil.createCompactMD5(string2));
            this.className = stringBuilder.toString();
        }
        return this.className;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getFileName() {
        File file = this.resource.getFile();
        URI uRI = this.resource.getURI();
        return file != null ? file.getPath() : uRI.toString();
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }
}

