/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import org.gradle.api.internal.DirectInstantiator;
import org.gradle.api.internal.Instantiator;
import org.gradle.groovy.scripts.CachingScriptSource;
import org.gradle.groovy.scripts.Script;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.groovy.scripts.internal.ScriptRunnerFactory;

public class DefaultScriptCompilerFactory
implements ScriptCompilerFactory {
    private final ScriptRunnerFactory scriptRunnerFactory;
    private final ScriptClassCompiler scriptClassCompiler;

    public DefaultScriptCompilerFactory(ScriptClassCompiler scriptClassCompiler, ScriptRunnerFactory scriptRunnerFactory) {
        this.scriptClassCompiler = scriptClassCompiler;
        this.scriptRunnerFactory = scriptRunnerFactory;
    }

    public ScriptCompiler createCompiler(ScriptSource scriptSource) {
        return new ScriptCompilerImpl(scriptSource);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptCompilerImpl
    implements ScriptCompiler {
        private final ScriptSource source;
        private ClassLoader classloader;
        private Transformer transformer;
        private final Instantiator instantiator = new DirectInstantiator();

        public ScriptCompilerImpl(ScriptSource scriptSource) {
            this.source = new CachingScriptSource(scriptSource);
        }

        @Override
        public ScriptCompiler setClassloader(ClassLoader classLoader) {
            this.classloader = classLoader;
            return this;
        }

        @Override
        public ScriptCompiler setTransformer(Transformer transformer) {
            this.transformer = transformer;
            return this;
        }

        @Override
        public <T extends Script> ScriptRunner<T> compile(Class<T> clazz) {
            Class<T> clazz2 = DefaultScriptCompilerFactory.this.scriptClassCompiler.compile(this.source, this.classloader, this.transformer, clazz);
            Script script = (Script)((Object)this.instantiator.newInstance(clazz2, new Object[0]));
            script.setScriptSource(this.source);
            script.setContextClassloader(this.classloader);
            return DefaultScriptCompilerFactory.this.scriptRunnerFactory.create(script);
        }
    }
}

