/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelectionException;
import org.gradle.util.NameMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskSelector {
    private final TaskNameResolver taskNameResolver;
    private Set<Task> tasks;
    private String taskName;

    public TaskSelector() {
        this(new TaskNameResolver());
    }

    public TaskSelector(TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
    }

    public void selectTasks(GradleInternal gradleInternal, String string) {
        SetMultimap<String, Task> setMultimap;
        String string2;
        String string3;
        Object object;
        ProjectInternal projectInternal = gradleInternal.getDefaultProject();
        if (string.contains(":")) {
            object = StringUtils.substringBeforeLast((String)string, (String)":");
            object = ((String)object).length() == 0 ? ":" : object;
            projectInternal = TaskSelector.findProject(projectInternal, (String)object);
            string3 = StringUtils.substringAfterLast((String)string, (String)":");
            string2 = projectInternal.getPath() + ":";
            setMultimap = this.taskNameResolver.select(string3, projectInternal);
        } else {
            string3 = string;
            string2 = "";
            setMultimap = this.taskNameResolver.selectAll(string, projectInternal);
        }
        object = setMultimap.get((Object)string3);
        if (!object.isEmpty()) {
            this.tasks = object;
            this.taskName = string;
            return;
        }
        NameMatcher nameMatcher = new NameMatcher();
        String string4 = nameMatcher.find(string3, setMultimap.keySet());
        if (string4 != null) {
            this.tasks = setMultimap.get((Object)string4);
            this.taskName = string2 + string4;
            return;
        }
        throw new TaskSelectionException(nameMatcher.formatErrorMessage("task", projectInternal));
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Set<Task> getTasks() {
        return this.tasks;
    }

    private static ProjectInternal findProject(ProjectInternal projectInternal, String string) {
        if (string.equals(":")) {
            return projectInternal.getRootProject();
        }
        Project project = projectInternal;
        if (string.startsWith(":")) {
            project = project.getRootProject();
            string = string.substring(1);
        }
        String[] stringArray = string.split(":");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            NameMatcher nameMatcher = new NameMatcher();
            String string2 = stringArray[i];
            Map<String, Project> map = project.getChildProjects();
            Project project2 = nameMatcher.find(string2, map);
            if (project2 == null) {
                throw new TaskSelectionException(nameMatcher.formatErrorMessage("project", project));
            }
            project = project2;
        }
        return project;
    }
}

