/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.tasks.CommandLineOption;
import org.gradle.cli.CommandLineParser;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelector;
import org.gradle.util.GUtil;
import org.gradle.util.JavaMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolvingBuildConfigurationAction
implements BuildConfigurationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskNameResolvingBuildConfigurationAction.class);
    private final TaskNameResolver taskNameResolver;

    public TaskNameResolvingBuildConfigurationAction() {
        this(new TaskNameResolver());
    }

    TaskNameResolvingBuildConfigurationAction(TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
    }

    @Override
    public void configure(BuildExecutionContext buildExecutionContext) {
        GradleInternal gradleInternal = buildExecutionContext.getGradle();
        List<String> list = gradleInternal.getStartParameter().getTaskNames();
        Multimap<String, Task> multimap = this.doSelect(gradleInternal, list, this.taskNameResolver);
        TaskGraphExecuter taskGraphExecuter = gradleInternal.getTaskGraph();
        for (String string : multimap.keySet()) {
            taskGraphExecuter.addTasks(multimap.get((Object)string));
        }
        if (multimap.keySet().size() == 1) {
            LOGGER.info("Selected primary task {}", (Object)GUtil.toString(multimap.keySet()));
        } else {
            LOGGER.info("Selected primary tasks {}", (Object)GUtil.toString(multimap.keySet()));
        }
        buildExecutionContext.proceed();
    }

    private Multimap<String, Task> doSelect(GradleInternal gradleInternal, List<String> list, TaskNameResolver taskNameResolver) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        TaskSelector taskSelector = new TaskSelector(taskNameResolver);
        List list2 = list;
        while (!list2.isEmpty()) {
            Object object;
            String string = (String)list2.get(0);
            taskSelector.selectTasks(gradleInternal, string);
            CommandLineParser commandLineParser = new CommandLineParser();
            Set<Task> set = taskSelector.getTasks();
            HashMap<String, JavaMethod<Task, Object>> hashMap = new HashMap<String, JavaMethod<Task, Object>>();
            if (set.size() == 1) {
                for (object = set.iterator().next().getClass(); object != Object.class; object = object.getSuperclass()) {
                    for (Method method : object.getDeclaredMethods()) {
                        CommandLineOption commandLineOption = method.getAnnotation(CommandLineOption.class);
                        if (commandLineOption == null) continue;
                        commandLineParser.option(commandLineOption.options()).hasDescription(commandLineOption.description());
                        hashMap.put(commandLineOption.options()[0], JavaMethod.create(Task.class, Object.class, method));
                    }
                }
            }
            object = commandLineParser.parse(list2.subList(1, list2.size()));
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!object.hasOption((String)entry.getKey())) continue;
                for (Task task : set) {
                    ((JavaMethod)entry.getValue()).invoke(task, true);
                }
            }
            list2 = object.getExtraArguments();
            linkedHashMultimap.putAll((Object)taskSelector.getTaskName(), set);
        }
        return linkedHashMultimap;
    }
}

