/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolver {
    public SetMultimap<String, Task> select(String string, Project project) {
        return this.select(string, (ProjectInternal)project, Collections.<Project>emptySet());
    }

    public SetMultimap<String, Task> selectAll(String string, Project project) {
        return this.select(string, (ProjectInternal)project, project.getSubprojects());
    }

    private SetMultimap<String, Task> select(String string, ProjectInternal projectInternal, Iterable<Project> iterable) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Task task = (Task)projectInternal.getTasks().findByName(string);
        if (task != null) {
            linkedHashMultimap.put((Object)task.getName(), (Object)task);
        } else {
            task = (Task)projectInternal.getImplicitTasks().findByName(string);
            if (task != null) {
                linkedHashMultimap.put((Object)task.getName(), (Object)task);
            }
        }
        for (Project comparable : iterable) {
            task = (Task)comparable.getTasks().findByName(string);
            if (task == null) continue;
            linkedHashMultimap.put((Object)task.getName(), (Object)task);
        }
        if (!linkedHashMultimap.isEmpty()) {
            return linkedHashMultimap;
        }
        for (Task task2 : projectInternal.getTasks()) {
            linkedHashMultimap.put((Object)task2.getName(), (Object)task2);
        }
        for (Task task3 : projectInternal.getImplicitTasks()) {
            if (linkedHashMultimap.containsKey((Object)task3.getName())) continue;
            linkedHashMultimap.put((Object)task3.getName(), (Object)task3);
        }
        for (Project project : iterable) {
            for (Task task4 : project.getTasks()) {
                linkedHashMultimap.put((Object)task4.getName(), (Object)task4);
            }
        }
        return linkedHashMultimap;
    }
}

