/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractMultiCauseException;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildExecutionAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.internal.UncheckedException;

public class SelectedTaskExecutionAction
implements BuildExecutionAction {
    public void execute(BuildExecutionContext buildExecutionContext) {
        GradleInternal gradleInternal = buildExecutionContext.getGradle();
        TaskGraphExecuter taskGraphExecuter = gradleInternal.getTaskGraph();
        if (gradleInternal.getStartParameter().isContinueOnFailure()) {
            MultipleFailuresHandler multipleFailuresHandler = new MultipleFailuresHandler();
            taskGraphExecuter.useFailureHandler(multipleFailuresHandler);
            taskGraphExecuter.execute();
            multipleFailuresHandler.rethrowFailures();
        } else {
            taskGraphExecuter.execute();
        }
    }

    private static class MultipleFailuresHandler
    implements TaskFailureHandler {
        final List<Throwable> failures = new ArrayList<Throwable>();

        private MultipleFailuresHandler() {
        }

        public void onTaskFailure(Task task) {
            this.failures.add(task.getState().getFailure());
        }

        public void rethrowFailures() {
            if (this.failures.isEmpty()) {
                return;
            }
            if (this.failures.size() == 1) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.failures.get(0));
            }
            throw new AbstractMultiCauseException("Multiple tasks failed.", this.failures);
        }
    }
}

