/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.execution.TaskSelector;

public class ExcludedTaskFilteringBuildConfigurationAction
implements BuildConfigurationAction {
    private final TaskSelector selector;

    public ExcludedTaskFilteringBuildConfigurationAction() {
        this(new TaskSelector());
    }

    ExcludedTaskFilteringBuildConfigurationAction(TaskSelector taskSelector) {
        this.selector = taskSelector;
    }

    public void configure(BuildExecutionContext buildExecutionContext) {
        GradleInternal gradleInternal = buildExecutionContext.getGradle();
        Set<String> set = gradleInternal.getStartParameter().getExcludedTaskNames();
        if (!set.isEmpty()) {
            final HashSet<Task> hashSet = new HashSet<Task>();
            for (String string : set) {
                this.selector.selectTasks(gradleInternal, string);
                hashSet.addAll(this.selector.getTasks());
            }
            gradleInternal.getTaskGraph().useFilter((Spec<? super Task>)new Spec<Task>(){

                @Override
                public boolean isSatisfiedBy(Task task) {
                    return !hashSet.contains(task);
                }
            });
        }
        buildExecutionContext.proceed();
    }
}

