/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Arrays;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTasksBuildExecutionAction
implements BuildConfigurationAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTasksBuildExecutionAction.class);

    public void configure(BuildExecutionContext buildExecutionContext) {
        StartParameter startParameter = buildExecutionContext.getGradle().getStartParameter();
        if (!startParameter.getTaskNames().isEmpty()) {
            buildExecutionContext.proceed();
            return;
        }
        ProjectInternal projectInternal = buildExecutionContext.getGradle().getDefaultProject();
        List<String> list = projectInternal.getDefaultTasks();
        if (list.size() == 0) {
            list = Arrays.asList("help");
            LOGGER.info("No tasks specified. Using default task {}", (Object)GUtil.toString(list));
        } else {
            LOGGER.info("No tasks specified. Using project default tasks {}", (Object)GUtil.toString(list));
        }
        startParameter.setTaskNames(list);
        buildExecutionContext.proceed();
    }
}

