/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import groovy.lang.Closure;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.CachingTaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.TaskFailureHandler;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskGraphExecuter
implements TaskGraphExecuter {
    private static Logger logger = LoggerFactory.getLogger(DefaultTaskGraphExecuter.class);
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final Map<Task, TaskInfo> executionPlan = new LinkedHashMap<Task, TaskInfo>();
    private boolean populated;
    private Spec<? super Task> filter = Specs.satisfyAll();
    private TaskFailureHandler failureHandler = new TaskFailureHandler(){

        public void onTaskFailure(Task task) {
            task.getState().rethrowFailure();
        }
    };

    public DefaultTaskGraphExecuter(ListenerManager listenerManager) {
        this.graphListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionGraphListener.class);
        this.taskListeners = listenerManager.createAnonymousBroadcaster(TaskExecutionListener.class);
    }

    @Override
    public void useFilter(Spec<? super Task> spec) {
        this.filter = spec;
    }

    @Override
    public void addTasks(Iterable<? extends Task> iterable) {
        assert (iterable != null);
        Clock clock = new Clock();
        TreeSet<Task> treeSet = new TreeSet<Task>();
        for (Task task : iterable) {
            treeSet.add(task);
        }
        this.fillDag(treeSet);
        this.populated = true;
        logger.debug("Timing: Creating the DAG took " + clock.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Clock clock = new Clock();
        this.graphListeners.getSource().graphPopulated(this);
        try {
            this.doExecute(this.executionPlan.values());
            logger.debug("Timing: Executing the DAG took " + clock.getTime());
        }
        finally {
            this.executionPlan.clear();
        }
    }

    public void execute(Iterable<? extends Task> iterable) {
        this.addTasks(iterable);
        this.execute();
    }

    private void fillDag(Collection<? extends Task> collection) {
        HashSet<Task> hashSet = new HashSet<Task>();
        ArrayList<? extends Task> arrayList = new ArrayList<Task>();
        arrayList.addAll(collection);
        CachingTaskDependencyResolveContext cachingTaskDependencyResolveContext = new CachingTaskDependencyResolveContext();
        while (!arrayList.isEmpty()) {
            AbstractSet abstractSet;
            Task task = (Task)arrayList.get(0);
            if (!this.filter.isSatisfiedBy(task)) {
                arrayList.remove(0);
                continue;
            }
            if (this.executionPlan.containsKey(task)) {
                arrayList.remove(0);
                continue;
            }
            if (hashSet.add(task)) {
                abstractSet = new TreeSet(Collections.reverseOrder());
                abstractSet.addAll(cachingTaskDependencyResolveContext.getDependencies(task));
                for (Task task2 : abstractSet) {
                    if (hashSet.contains(task2)) {
                        throw new CircularReferenceException(String.format("Circular dependency between tasks. Cycle includes [%s, %s].", task, task2));
                    }
                    arrayList.add(0, task2);
                }
                continue;
            }
            arrayList.remove(0);
            hashSet.remove(task);
            abstractSet = new HashSet();
            for (Task task3 : cachingTaskDependencyResolveContext.getDependencies(task)) {
                TaskInfo taskInfo = this.executionPlan.get(task3);
                if (taskInfo == null) continue;
                abstractSet.add(taskInfo);
            }
            this.executionPlan.put(task, new TaskInfo((TaskInternal)task, abstractSet));
        }
    }

    @Override
    public void addTaskExecutionGraphListener(TaskExecutionGraphListener taskExecutionGraphListener) {
        this.graphListeners.add(taskExecutionGraphListener);
    }

    @Override
    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener taskExecutionGraphListener) {
        this.graphListeners.remove(taskExecutionGraphListener);
    }

    @Override
    public void whenReady(Closure closure) {
        this.graphListeners.add("graphPopulated", closure);
    }

    @Override
    public void addTaskExecutionListener(TaskExecutionListener taskExecutionListener) {
        this.taskListeners.add(taskExecutionListener);
    }

    @Override
    public void removeTaskExecutionListener(TaskExecutionListener taskExecutionListener) {
        this.taskListeners.remove(taskExecutionListener);
    }

    @Override
    public void beforeTask(Closure closure) {
        this.taskListeners.add("beforeExecute", closure);
    }

    @Override
    public void afterTask(Closure closure) {
        this.taskListeners.add("afterExecute", closure);
    }

    @Override
    public void useFailureHandler(TaskFailureHandler taskFailureHandler) {
        this.failureHandler = taskFailureHandler;
    }

    private void doExecute(Iterable<? extends TaskInfo> iterable) {
        for (TaskInfo taskInfo : iterable) {
            this.executeTask(taskInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(TaskInfo taskInfo) {
        TaskInternal taskInternal = taskInfo.task;
        for (TaskInfo taskInfo2 : taskInfo.dependencies) {
            if (taskInfo2.executed) continue;
            return;
        }
        this.taskListeners.getSource().beforeExecute(taskInternal);
        try {
            taskInternal.executeWithoutThrowingTaskFailure();
            if (taskInternal.getState().getFailure() != null) {
                this.failureHandler.onTaskFailure(taskInternal);
            } else {
                taskInfo.executed = true;
            }
        }
        finally {
            this.taskListeners.getSource().afterExecute(taskInternal, taskInternal.getState());
        }
    }

    @Override
    public boolean hasTask(Task task) {
        this.assertPopulated();
        return this.executionPlan.containsKey(task);
    }

    @Override
    public boolean hasTask(String string) {
        this.assertPopulated();
        assert (string != null && string.length() > 0);
        for (Task task : this.getAllTasks()) {
            if (!task.getPath().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Task> getAllTasks() {
        this.assertPopulated();
        return new ArrayList<Task>(this.executionPlan.keySet());
    }

    private void assertPopulated() {
        if (!this.populated) {
            throw new IllegalStateException("Task information is not available, as this task execution graph has not been populated.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskInfo {
        private final TaskInternal task;
        private final Set<TaskInfo> dependencies;
        private boolean executed;

        private TaskInfo(TaskInternal taskInternal, Set<TaskInfo> set) {
            this.task = taskInternal;
            this.dependencies = set;
        }
    }
}

