/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.BuildExecutionAction;
import org.gradle.execution.BuildExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildExecuter
implements BuildExecuter {
    private final List<BuildConfigurationAction> configurationActions;
    private final List<BuildExecutionAction> executionActions;
    private GradleInternal gradle;

    public DefaultBuildExecuter(Iterable<? extends BuildConfigurationAction> iterable, Iterable<? extends BuildExecutionAction> iterable2) {
        this.configurationActions = Lists.newArrayList(iterable);
        this.executionActions = Lists.newArrayList(iterable2);
    }

    @Override
    public void select(GradleInternal gradleInternal) {
        this.gradle = gradleInternal;
        this.configure(0);
    }

    private void configure(final int n) {
        if (n >= this.configurationActions.size()) {
            return;
        }
        this.configurationActions.get(n).configure(new BuildExecutionContext(){

            public GradleInternal getGradle() {
                return DefaultBuildExecuter.this.gradle;
            }

            public void proceed() {
                DefaultBuildExecuter.this.configure(n + 1);
            }
        });
    }

    @Override
    public void execute() {
        this.execute(0);
    }

    private void execute(final int n) {
        if (n >= this.executionActions.size()) {
            return;
        }
        this.executionActions.get(n).execute(new BuildExecutionContext(){

            public GradleInternal getGradle() {
                return DefaultBuildExecuter.this.gradle;
            }

            public void proceed() {
                DefaultBuildExecuter.this.execute(n + 1);
            }
        });
    }
}

