/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.gradle.configuration.ImportsScriptSource;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.UncheckedException;

public class ImportsReader {
    private String importsText;

    public String getImports() {
        if (this.importsText == null) {
            try {
                URL uRL = this.getClass().getResource("default-imports.txt");
                InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), "UTF8");
                int n = 2048;
                StringBuilder stringBuilder = new StringBuilder(n);
                char[] cArray = new char[n];
                int n2 = inputStreamReader.read(cArray, 0, n);
                while (n2 != -1) {
                    stringBuilder.append(cArray, 0, n2);
                    n2 = inputStreamReader.read(cArray, 0, n);
                }
                this.importsText = stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw UncheckedException.throwAsUncheckedException((Throwable)iOException);
            }
        }
        return this.importsText;
    }

    public ScriptSource withImports(ScriptSource scriptSource) {
        return new ImportsScriptSource(scriptSource, this);
    }
}

