/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.configuration.ProjectEvaluator;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildScriptProcessor
implements ProjectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildScriptProcessor.class);
    private final ScriptPluginFactory configurerFactory;

    public BuildScriptProcessor(ScriptPluginFactory scriptPluginFactory) {
        this.configurerFactory = scriptPluginFactory;
    }

    public void evaluate(ProjectInternal projectInternal, ProjectStateInternal projectStateInternal) {
        LOGGER.info(String.format("Evaluating %s using %s.", projectInternal, projectInternal.getBuildScriptSource().getDisplayName()));
        Clock clock = new Clock();
        try {
            ScriptPlugin scriptPlugin = this.configurerFactory.create(projectInternal.getBuildScriptSource());
            scriptPlugin.apply(projectInternal);
        }
        catch (Exception exception) {
            projectStateInternal.executed(exception);
        }
        LOGGER.debug("Timing: Running the build script took " + clock.getTime());
    }
}

