/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateCheckBlockStore
implements BlockStore {
    private final BlockStore blockStore;
    private boolean open;

    public StateCheckBlockStore(BlockStore blockStore) {
        this.blockStore = blockStore;
    }

    @Override
    public void open(Runnable runnable, BlockStore.Factory factory) {
        assert (!this.open);
        this.open = true;
        this.blockStore.open(runnable, factory);
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.blockStore.close();
    }

    @Override
    public void clear() {
        assert (this.open);
        this.blockStore.clear();
    }

    @Override
    public void remove(BlockPayload blockPayload) {
        assert (this.open);
        this.blockStore.remove(blockPayload);
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> clazz) {
        assert (this.open);
        return this.blockStore.readFirst(clazz);
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer blockPointer, Class<T> clazz) {
        assert (this.open);
        return this.blockStore.read(blockPointer, clazz);
    }

    @Override
    public void write(BlockPayload blockPayload) {
        assert (this.open);
        this.blockStore.write(blockPayload);
    }

    @Override
    public void attach(BlockPayload blockPayload) {
        assert (this.open);
        this.blockStore.attach(blockPayload);
    }

    @Override
    public void flush() {
        assert (this.open);
        this.blockStore.flush();
    }
}

