/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.util.concurrent.Callable;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockingBlockStore
implements BlockStore {
    private final BlockStore store;
    private final FileAccess fileAccess;

    public LockingBlockStore(BlockStore blockStore, FileAccess fileAccess) {
        this.store = blockStore;
        this.fileAccess = fileAccess;
    }

    @Override
    public void open(final Runnable runnable, BlockStore.Factory factory) {
        this.store.open(new Runnable(){

            public void run() {
                LockingBlockStore.this.fileAccess.writeToFile(runnable);
            }
        }, factory);
    }

    @Override
    public void close() {
        this.store.close();
    }

    @Override
    public void flush() {
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.flush();
            }
        });
    }

    @Override
    public void clear() {
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.clear();
            }
        });
    }

    @Override
    public void attach(BlockPayload blockPayload) {
        this.store.attach(blockPayload);
    }

    @Override
    public <T extends BlockPayload> T read(final BlockPointer blockPointer, final Class<T> clazz) {
        return (T)((BlockPayload)this.fileAccess.readFromFile(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LockingBlockStore.this.store.read(blockPointer, clazz);
            }
        }));
    }

    @Override
    public <T extends BlockPayload> T readFirst(final Class<T> clazz) {
        return (T)((BlockPayload)this.fileAccess.readFromFile(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LockingBlockStore.this.store.readFirst(clazz);
            }
        }));
    }

    @Override
    public void write(final BlockPayload blockPayload) {
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.write(blockPayload);
            }
        });
    }

    @Override
    public void remove(final BlockPayload blockPayload) {
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                LockingBlockStore.this.store.remove(blockPayload);
            }
        });
    }
}

