/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.cache.internal.btree.Block;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeListBlockStore
implements BlockStore {
    private final BlockStore store;
    private final BlockStore freeListStore;
    private final int maxBlockEntries;
    private FreeListBlock freeListBlock;

    public FreeListBlockStore(BlockStore blockStore, int n) {
        this.store = blockStore;
        this.freeListStore = this;
        this.maxBlockEntries = n;
    }

    @Override
    public void open(final Runnable runnable, final BlockStore.Factory factory) {
        Runnable runnable2 = new Runnable(){

            public void run() {
                FreeListBlockStore.this.freeListBlock = new FreeListBlock();
                FreeListBlockStore.this.store.write(FreeListBlockStore.this.freeListBlock);
                FreeListBlockStore.this.store.flush();
                runnable.run();
            }
        };
        BlockStore.Factory factory2 = new BlockStore.Factory(){

            @Override
            public Object create(Class<? extends BlockPayload> clazz) {
                if (clazz == FreeListBlock.class) {
                    return new FreeListBlock();
                }
                return factory.create(clazz);
            }
        };
        this.store.open(runnable2, factory2);
        this.freeListBlock = this.store.readFirst(FreeListBlock.class);
    }

    @Override
    public void close() {
        this.freeListBlock = null;
        this.store.close();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void remove(BlockPayload blockPayload) {
        Block block = blockPayload.getBlock();
        this.store.remove(blockPayload);
        this.freeListBlock.add(block.getPos(), block.getSize());
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> clazz) {
        return this.store.read(this.freeListBlock.getNextPos(), clazz);
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer blockPointer, Class<T> clazz) {
        return this.store.read(blockPointer, clazz);
    }

    @Override
    public void write(BlockPayload blockPayload) {
        this.attach(blockPayload);
        this.store.write(blockPayload);
    }

    @Override
    public void attach(BlockPayload blockPayload) {
        this.store.attach(blockPayload);
        this.freeListBlock.alloc(blockPayload.getBlock());
    }

    @Override
    public void flush() {
        this.store.flush();
    }

    private void verify() {
        FreeListBlock freeListBlock = this.store.readFirst(FreeListBlock.class);
        this.verify(freeListBlock, Integer.MAX_VALUE);
    }

    private void verify(FreeListBlock freeListBlock, int n) {
        if (freeListBlock.largestInNextBlock > n) {
            throw new RuntimeException("corrupt free list");
        }
        int n2 = 0;
        for (FreeListEntry freeListEntry : freeListBlock.entries) {
            if (freeListEntry.size > n) {
                throw new RuntimeException("corrupt free list");
            }
            if (freeListEntry.size < freeListBlock.largestInNextBlock) {
                throw new RuntimeException("corrupt free list");
            }
            if (freeListEntry.size < n2) {
                throw new RuntimeException("corrupt free list");
            }
            n2 = freeListEntry.size;
        }
        if (!freeListBlock.nextBlock.isNull()) {
            this.verify(this.store.read(freeListBlock.nextBlock, FreeListBlock.class), freeListBlock.largestInNextBlock);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FreeListEntry
    implements Comparable<FreeListEntry> {
        final BlockPointer pos;
        final int size;

        private FreeListEntry(BlockPointer blockPointer, int n) {
            this.pos = blockPointer;
            this.size = n;
        }

        @Override
        public int compareTo(FreeListEntry freeListEntry) {
            if (this.size > freeListEntry.size) {
                return 1;
            }
            if (this.size < freeListEntry.size) {
                return -1;
            }
            return 0;
        }
    }

    public class FreeListBlock
    extends BlockPayload {
        private List<FreeListEntry> entries = new ArrayList<FreeListEntry>();
        private int largestInNextBlock;
        private BlockPointer nextBlock = new BlockPointer();
        private FreeListBlock prev;
        private FreeListBlock next;

        protected int getSize() {
            return 16 + FreeListBlockStore.this.maxBlockEntries * 12;
        }

        protected int getType() {
            return 68;
        }

        protected void read(DataInputStream dataInputStream) throws Exception {
            this.nextBlock = new BlockPointer(dataInputStream.readLong());
            this.largestInNextBlock = dataInputStream.readInt();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                BlockPointer blockPointer = new BlockPointer(dataInputStream.readLong());
                int n2 = dataInputStream.readInt();
                this.entries.add(new FreeListEntry(blockPointer, n2));
            }
        }

        protected void write(DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeLong(this.nextBlock.getPos());
            dataOutputStream.writeInt(this.largestInNextBlock);
            dataOutputStream.writeInt(this.entries.size());
            for (FreeListEntry freeListEntry : this.entries) {
                dataOutputStream.writeLong(freeListEntry.pos.getPos());
                dataOutputStream.writeInt(freeListEntry.size);
            }
        }

        public void add(BlockPointer blockPointer, int n) {
            assert (!blockPointer.isNull() && n >= 0);
            if (n == 0) {
                return;
            }
            if (n < this.largestInNextBlock) {
                FreeListBlock freeListBlock = this.getNextBlock();
                freeListBlock.add(blockPointer, n);
                return;
            }
            FreeListEntry freeListEntry = new FreeListEntry(blockPointer, n);
            int n2 = Collections.binarySearch(this.entries, freeListEntry);
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            this.entries.add(n2, freeListEntry);
            if (this.entries.size() > FreeListBlockStore.this.maxBlockEntries) {
                FreeListBlock freeListBlock = new FreeListBlock();
                freeListBlock.largestInNextBlock = this.largestInNextBlock;
                freeListBlock.nextBlock = this.nextBlock;
                freeListBlock.prev = this;
                freeListBlock.next = this.next;
                this.next = freeListBlock;
                List<FreeListEntry> list = this.entries.subList(0, this.entries.size() / 2);
                freeListBlock.entries.addAll(list);
                list.clear();
                this.largestInNextBlock = freeListBlock.entries.get((int)(freeListBlock.entries.size() - 1)).size;
                FreeListBlockStore.this.freeListStore.write(freeListBlock);
                this.nextBlock = freeListBlock.getPos();
            }
            FreeListBlockStore.this.freeListStore.write(this);
        }

        private FreeListBlock getNextBlock() {
            if (this.next == null) {
                this.next = FreeListBlockStore.this.freeListStore.read(this.nextBlock, FreeListBlock.class);
                this.next.prev = this;
            }
            return this.next;
        }

        public void alloc(Block block) {
            if (block.hasPos()) {
                return;
            }
            int n = block.getSize();
            if (this.entries.isEmpty() || n <= this.largestInNextBlock) {
                if (this.nextBlock.isNull()) {
                    return;
                }
                this.getNextBlock().alloc(block);
                return;
            }
            int n2 = Collections.binarySearch(this.entries, new FreeListEntry(null, n));
            if (n2 < 0) {
                n2 = -n2 - 1;
            }
            if (n2 == this.entries.size()) {
                return;
            }
            FreeListEntry freeListEntry = this.entries.remove(n2);
            block.setPos(freeListEntry.pos);
            block.setSize(freeListEntry.size);
            FreeListBlockStore.this.freeListStore.write(this);
            if (this.entries.size() == 0 && this.prev != null) {
                this.prev.nextBlock = this.nextBlock;
                this.prev.largestInNextBlock = this.largestInNextBlock;
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                FreeListBlockStore.this.freeListStore.write(this.prev);
                FreeListBlockStore.this.freeListStore.remove(this);
            }
        }
    }
}

