/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.internal.btree.Block;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;
import org.gradle.cache.internal.btree.CorruptedCacheException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBackedBlockStore
implements BlockStore {
    private RandomAccessFile file;
    private final File cacheFile;
    private long nextBlock;
    private BlockStore.Factory factory;

    public FileBackedBlockStore(File file) {
        this.cacheFile = file;
    }

    public String toString() {
        return String.format("cache '%s'", this.cacheFile);
    }

    @Override
    public void open(Runnable runnable, BlockStore.Factory factory) {
        this.factory = factory;
        try {
            this.file = new RandomAccessFile(this.cacheFile, "rw");
            this.nextBlock = this.file.length();
            if (this.file.length() == 0L) {
                runnable.run();
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void clear() {
        try {
            this.file.setLength(0L);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        this.nextBlock = 0L;
    }

    @Override
    public void attach(BlockPayload blockPayload) {
        if (blockPayload.getBlock() == null) {
            blockPayload.setBlock(new BlockImpl(blockPayload));
        }
    }

    @Override
    public void remove(BlockPayload blockPayload) {
        BlockImpl blockImpl = (BlockImpl)blockPayload.getBlock();
        blockImpl.detach();
    }

    @Override
    public void flush() {
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> clazz) {
        return this.read(new BlockPointer(0L), clazz);
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer blockPointer, Class<T> clazz) {
        assert (!blockPointer.isNull());
        try {
            BlockPayload blockPayload = (BlockPayload)clazz.cast(this.factory.create(clazz));
            BlockImpl blockImpl = new BlockImpl(blockPayload, blockPointer);
            blockImpl.read();
            return (T)blockPayload;
        }
        catch (CorruptedCacheException corruptedCacheException) {
            throw corruptedCacheException;
        }
        catch (Exception exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @Override
    public void write(BlockPayload blockPayload) {
        BlockImpl blockImpl = (BlockImpl)blockPayload.getBlock();
        try {
            blockImpl.write();
        }
        catch (CorruptedCacheException corruptedCacheException) {
            throw corruptedCacheException;
        }
        catch (Exception exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private long alloc(long l) {
        long l2 = this.nextBlock;
        this.nextBlock += l;
        return l2;
    }

    private static class Crc32OutputStream
    extends FilterOutputStream {
        private final CRC32 checksum = new CRC32();

        private Crc32OutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(int n) throws IOException {
            this.checksum.update(n);
            this.out.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.checksum.update(byArray);
            this.out.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.checksum.update(byArray, n, n2);
            this.out.write(byArray, n, n2);
        }
    }

    private static class Crc32InputStream
    extends FilterInputStream {
        private final CRC32 checksum = new CRC32();

        private Crc32InputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n >= 0) {
                this.checksum.update(n);
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            int n = this.in.read(byArray);
            if (n > 0) {
                this.checksum.update(byArray, 0, n);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 > 0) {
                this.checksum.update(byArray, n, n3);
            }
            return n3;
        }
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        private final RandomAccessFile file;

        private RandomAccessFileOutputStream(RandomAccessFile randomAccessFile) {
            this.file = randomAccessFile;
        }

        public void write(int n) throws IOException {
            this.file.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.file.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.file.write(byArray, n, n2);
        }
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        private final RandomAccessFile file;

        private RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
            this.file = randomAccessFile;
        }

        public int read(byte[] byArray) throws IOException {
            return this.file.read(byArray);
        }

        public int read() throws IOException {
            return this.file.read();
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.file.read(byArray, n, n2);
        }
    }

    private final class BlockImpl
    extends Block {
        private static final int HEADER_SIZE = 6;
        private static final int TAIL_SIZE = 8;
        static final int BLOCK_MARKER = 204;
        private BlockPointer pos;
        private int payloadSize;

        private BlockImpl(BlockPayload blockPayload, BlockPointer blockPointer) {
            this(blockPayload);
            this.setPos(blockPointer);
        }

        public BlockImpl(BlockPayload blockPayload) {
            super(blockPayload);
            this.pos = null;
            this.payloadSize = -1;
        }

        public boolean hasPos() {
            return this.pos != null;
        }

        public BlockPointer getPos() {
            if (this.pos == null) {
                this.pos = new BlockPointer(FileBackedBlockStore.this.alloc(this.getSize()));
            }
            return this.pos;
        }

        public void setPos(BlockPointer blockPointer) {
            assert (this.pos == null && !blockPointer.isNull());
            this.pos = blockPointer;
        }

        public int getSize() {
            if (this.payloadSize < 0) {
                this.payloadSize = this.getPayload().getSize();
            }
            return this.payloadSize + 6 + 8;
        }

        public void setSize(int n) {
            int n2 = n - 6 - 8;
            assert (n2 >= this.payloadSize);
            this.payloadSize = n2;
        }

        public void write() throws Exception {
            long l = this.getPos().getPos();
            FileBackedBlockStore.this.file.seek(l);
            Crc32OutputStream crc32OutputStream = new Crc32OutputStream(new BufferedOutputStream(new RandomAccessFileOutputStream(FileBackedBlockStore.this.file)));
            DataOutputStream dataOutputStream = new DataOutputStream(crc32OutputStream);
            BlockPayload blockPayload = this.getPayload();
            dataOutputStream.writeByte(204);
            dataOutputStream.writeByte(blockPayload.getType());
            dataOutputStream.writeInt(this.payloadSize);
            long l2 = l + 6L + 8L + (long)this.payloadSize;
            blockPayload.write(dataOutputStream);
            dataOutputStream.writeLong(crc32OutputStream.checksum.getValue());
            dataOutputStream.close();
            if (FileBackedBlockStore.this.file.length() < l2) {
                FileBackedBlockStore.this.file.setLength(l2);
            }
        }

        public void read() throws Exception {
            long l = this.getPos().getPos();
            assert (l >= 0L);
            if (l + 6L >= FileBackedBlockStore.this.file.length()) {
                throw this.blockCorruptedException();
            }
            FileBackedBlockStore.this.file.seek(l);
            Crc32InputStream crc32InputStream = new Crc32InputStream(new BufferedInputStream(new RandomAccessFileInputStream(FileBackedBlockStore.this.file)));
            DataInputStream dataInputStream = new DataInputStream(crc32InputStream);
            BlockPayload blockPayload = this.getPayload();
            byte by = dataInputStream.readByte();
            if (by != -52) {
                throw this.blockCorruptedException();
            }
            by = dataInputStream.readByte();
            if (by != (byte)blockPayload.getType()) {
                throw this.blockCorruptedException();
            }
            this.payloadSize = dataInputStream.readInt();
            if (l + 6L + 8L + (long)this.payloadSize > FileBackedBlockStore.this.file.length()) {
                throw this.blockCorruptedException();
            }
            blockPayload.read(dataInputStream);
            long l2 = crc32InputStream.checksum.getValue();
            long l3 = dataInputStream.readLong();
            if (l2 != l3) {
                throw this.blockCorruptedException();
            }
            dataInputStream.close();
        }

        public RuntimeException blockCorruptedException() {
            return new CorruptedCacheException(String.format("Corrupted %s found in %s.", this, FileBackedBlockStore.this));
        }
    }
}

