/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingBlockStore
implements BlockStore {
    private final BlockStore store;
    private final Map<BlockPointer, BlockPayload> dirty = new LinkedHashMap<BlockPointer, BlockPayload>();
    private final Map<BlockPointer, BlockPayload> indexBlockCache = new LRUMap(100);
    private final Set<Class<?>> cachableTypes = new HashSet();

    public CachingBlockStore(BlockStore blockStore, Class<? extends BlockPayload> ... classArray) {
        this.store = blockStore;
        this.cachableTypes.addAll(Arrays.asList(classArray));
    }

    @Override
    public void open(Runnable runnable, BlockStore.Factory factory) {
        this.store.open(runnable, factory);
    }

    @Override
    public void close() {
        this.flush();
        this.indexBlockCache.clear();
        this.store.close();
    }

    @Override
    public void clear() {
        this.dirty.clear();
        this.indexBlockCache.clear();
        this.store.clear();
    }

    @Override
    public void flush() {
        Iterator<BlockPayload> iterator = this.dirty.values().iterator();
        while (iterator.hasNext()) {
            BlockPayload blockPayload = iterator.next();
            iterator.remove();
            this.store.write(blockPayload);
        }
        this.store.flush();
    }

    @Override
    public void attach(BlockPayload blockPayload) {
        this.store.attach(blockPayload);
    }

    @Override
    public void remove(BlockPayload blockPayload) {
        this.dirty.remove(blockPayload.getPos());
        this.indexBlockCache.remove(blockPayload.getPos());
        this.store.remove(blockPayload);
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> clazz) {
        T t = this.store.readFirst(clazz);
        this.maybeCache(t);
        return t;
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer blockPointer, Class<T> clazz) {
        BlockPayload blockPayload = (BlockPayload)clazz.cast(this.dirty.get(blockPointer));
        if (blockPayload != null) {
            return (T)blockPayload;
        }
        blockPayload = (BlockPayload)clazz.cast(this.indexBlockCache.get(blockPointer));
        if (blockPayload != null) {
            return (T)blockPayload;
        }
        blockPayload = this.store.read(blockPointer, clazz);
        this.maybeCache(blockPayload);
        return (T)blockPayload;
    }

    @Override
    public void write(BlockPayload blockPayload) {
        this.store.attach(blockPayload);
        this.maybeCache(blockPayload);
        this.dirty.put(blockPayload.getPos(), blockPayload);
    }

    private <T extends BlockPayload> void maybeCache(T t) {
        if (this.cachableTypes.contains(t.getClass())) {
            this.indexBlockCache.put(t.getPos(), t);
        }
    }
}

