/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.btree.Block;
import org.gradle.cache.internal.btree.BlockPayload;
import org.gradle.cache.internal.btree.BlockPointer;
import org.gradle.cache.internal.btree.BlockStore;
import org.gradle.cache.internal.btree.CachingBlockStore;
import org.gradle.cache.internal.btree.CorruptedCacheException;
import org.gradle.cache.internal.btree.FileBackedBlockStore;
import org.gradle.cache.internal.btree.FreeListBlockStore;
import org.gradle.cache.internal.btree.StateCheckBlockStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreePersistentIndexedCache<K, V>
implements PersistentIndexedCache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BTreePersistentIndexedCache.class);
    private final File cacheFile;
    private final Serializer<K> keySerializer;
    private final Serializer<V> serializer;
    private final short maxChildIndexEntries;
    private final int minIndexChildNodes;
    private final StateCheckBlockStore store;
    private HeaderBlock header;

    public BTreePersistentIndexedCache(File file, Serializer<K> serializer, Serializer<V> serializer2) {
        this(file, serializer, serializer2, 512, 512);
    }

    public BTreePersistentIndexedCache(File file, Serializer<K> serializer, Serializer<V> serializer2, short s, int n) {
        this.cacheFile = file;
        this.keySerializer = serializer;
        this.serializer = serializer2;
        this.maxChildIndexEntries = s;
        this.minIndexChildNodes = s / 2;
        CachingBlockStore cachingBlockStore = new CachingBlockStore(new FileBackedBlockStore(file), IndexBlock.class, FreeListBlockStore.FreeListBlock.class);
        this.store = new StateCheckBlockStore(new FreeListBlockStore(cachingBlockStore, n));
        try {
            this.open();
        }
        catch (Exception exception) {
            throw new UncheckedIOException(String.format("Could not open %s.", this), exception);
        }
    }

    public String toString() {
        return String.format("cache %s (%s)", this.cacheFile.getName(), this.cacheFile);
    }

    private void open() throws Exception {
        LOGGER.debug("Opening {}", (Object)this);
        try {
            this.doOpen();
        }
        catch (CorruptedCacheException corruptedCacheException) {
            this.rebuild();
        }
    }

    private void doOpen() throws Exception {
        BlockStore.Factory factory = new BlockStore.Factory(){

            @Override
            public Object create(Class<? extends BlockPayload> clazz) {
                if (clazz == HeaderBlock.class) {
                    return new HeaderBlock();
                }
                if (clazz == IndexBlock.class) {
                    return new IndexBlock();
                }
                if (clazz == DataBlock.class) {
                    return new DataBlock();
                }
                throw new UnsupportedOperationException();
            }
        };
        Runnable runnable = new Runnable(){

            public void run() {
                BTreePersistentIndexedCache.this.header = new HeaderBlock();
                BTreePersistentIndexedCache.this.store.write(BTreePersistentIndexedCache.this.header);
                BTreePersistentIndexedCache.this.header.index.newRoot();
                BTreePersistentIndexedCache.this.store.flush();
            }
        };
        this.store.open(runnable, factory);
        this.header = this.store.readFirst(HeaderBlock.class);
    }

    @Override
    public V get(K k) {
        try {
            try {
                DataBlock dataBlock = this.header.getRoot().get(k);
                if (dataBlock != null) {
                    return dataBlock.getValue();
                }
                return null;
            }
            catch (CorruptedCacheException corruptedCacheException) {
                this.rebuild();
                return null;
            }
        }
        catch (Exception exception) {
            throw new UncheckedIOException(String.format("Could not read entry '%s' from %s.", k, this), exception);
        }
    }

    @Override
    public void put(K k, V v) {
        try {
            DataBlock dataBlock;
            MessageDigestStream messageDigestStream = new MessageDigestStream();
            this.keySerializer.write(messageDigestStream, k);
            long l = messageDigestStream.getChecksum();
            Lookup lookup = this.header.getRoot().find(l);
            boolean bl = true;
            if (lookup.entry != null) {
                dataBlock = this.store.read(lookup.entry.dataBlock, DataBlock.class);
                boolean bl2 = bl = !dataBlock.useNewValue(v);
                if (bl) {
                    this.store.remove(dataBlock);
                }
            }
            if (bl) {
                dataBlock = new DataBlock(v);
                this.store.write(dataBlock);
                lookup.indexBlock.put(l, dataBlock.getPos());
            }
            this.store.flush();
        }
        catch (Exception exception) {
            throw new UncheckedIOException(String.format("Could not add entry '%s' to %s.", k, this), exception);
        }
    }

    @Override
    public void remove(K k) {
        try {
            Lookup lookup = this.header.getRoot().find(k);
            if (lookup.entry == null) {
                return;
            }
            lookup.indexBlock.remove(lookup.entry);
            DataBlock dataBlock = this.store.read(lookup.entry.dataBlock, DataBlock.class);
            this.store.remove(dataBlock);
            this.store.flush();
        }
        catch (Exception exception) {
            throw new UncheckedIOException(String.format("Could not remove entry '%s' from %s.", k, this), exception);
        }
    }

    private IndexBlock load(BlockPointer blockPointer, IndexRoot indexRoot, IndexBlock indexBlock, int n) {
        IndexBlock indexBlock2 = this.store.read(blockPointer, IndexBlock.class);
        indexBlock2.root = indexRoot;
        indexBlock2.parent = indexBlock;
        indexBlock2.parentEntryIndex = n;
        return indexBlock2;
    }

    public void reset() {
        this.close();
        try {
            this.open();
        }
        catch (Exception exception) {
            throw new UncheckedIOException(exception);
        }
    }

    public void close() {
        LOGGER.debug("Closing {}", (Object)this);
        try {
            this.store.close();
        }
        catch (Exception exception) {
            throw new UncheckedIOException(exception);
        }
    }

    public boolean isOpen() {
        return this.store.isOpen();
    }

    private void rebuild() throws Exception {
        LOGGER.warn(String.format("%s is corrupt. Discarding.", this));
        this.store.clear();
        this.close();
        this.doOpen();
    }

    public void verify() {
        try {
            this.doVerify();
        }
        catch (Exception exception) {
            throw new UncheckedIOException(String.format("Some problems were found when checking the integrity of %s.", this), exception);
        }
    }

    private void doVerify() throws Exception {
        ArrayList<BlockPayload> arrayList = new ArrayList<BlockPayload>();
        HeaderBlock headerBlock = this.store.readFirst(HeaderBlock.class);
        arrayList.add(headerBlock);
        this.verifyTree(headerBlock.getRoot(), "", arrayList, Long.MAX_VALUE, true);
        Collections.sort(arrayList, new Comparator<BlockPayload>(){

            @Override
            public int compare(BlockPayload blockPayload, BlockPayload blockPayload2) {
                return blockPayload.getPos().compareTo(blockPayload2.getPos());
            }
        });
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            Block block = ((BlockPayload)arrayList.get(i)).getBlock();
            Block block2 = ((BlockPayload)arrayList.get(i + 1)).getBlock();
            if (block.getPos().getPos() + (long)block.getSize() <= block2.getPos().getPos()) continue;
            throw new IOException(String.format("%s overlaps with %s", block, block2));
        }
    }

    private void verifyTree(IndexBlock indexBlock, String string, Collection<BlockPayload> collection, long l, boolean bl) throws Exception {
        boolean bl2;
        collection.add(indexBlock);
        if (!string.equals("") && indexBlock.entries.size() < this.maxChildIndexEntries / 2) {
            throw new IOException(String.format("Too few entries found in %s", indexBlock));
        }
        if (indexBlock.entries.size() > this.maxChildIndexEntries) {
            throw new IOException(String.format("Too many entries found in %s", indexBlock));
        }
        boolean bl3 = bl2 = indexBlock.entries.size() == 0 || ((IndexEntry)((IndexBlock)indexBlock).entries.get((int)0)).childIndexBlock.isNull();
        if (bl2 ^ indexBlock.tailPos.isNull()) {
            throw new IOException(String.format("Mismatched leaf/tail-node in %s", indexBlock));
        }
        long l2 = Long.MIN_VALUE;
        for (IndexEntry indexEntry : indexBlock.entries) {
            BlockPayload blockPayload;
            if (bl2 ^ indexEntry.childIndexBlock.isNull()) {
                throw new IOException(String.format("Mismatched leaf/non-leaf entry in %s", indexBlock));
            }
            if (indexEntry.hashCode >= l || indexEntry.hashCode <= l2) {
                throw new IOException(String.format("Out-of-order key in %s", indexBlock));
            }
            l2 = indexEntry.hashCode;
            if (!indexEntry.childIndexBlock.isNull()) {
                blockPayload = this.store.read(indexEntry.childIndexBlock, IndexBlock.class);
                this.verifyTree((IndexBlock)blockPayload, "   " + string, collection, indexEntry.hashCode, bl);
            }
            if (!bl) continue;
            blockPayload = this.store.read(indexEntry.dataBlock, DataBlock.class);
            collection.add(blockPayload);
        }
        if (!indexBlock.tailPos.isNull()) {
            IndexBlock indexBlock2 = this.store.read(indexBlock.tailPos, IndexBlock.class);
            this.verifyTree(indexBlock2, "   " + string, collection, l, bl);
        }
    }

    private static class MessageDigestStream
    extends OutputStream {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");

        private MessageDigestStream() throws NoSuchAlgorithmException {
        }

        public void write(int n) throws IOException {
            this.messageDigest.update((byte)n);
        }

        public void write(byte[] byArray) throws IOException {
            this.messageDigest.update(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.messageDigest.update(byArray, n, n2);
        }

        long getChecksum() {
            byte[] byArray = this.messageDigest.digest();
            assert (byArray.length == 16);
            return new BigInteger(byArray).longValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataBlock
    extends BlockPayload {
        private int size;
        private byte[] serialisedValue;
        private V value;

        private DataBlock() {
        }

        public DataBlock(V v) throws Exception {
            this.value = v;
            this.setValue(v);
            this.size = this.serialisedValue.length;
        }

        public void setValue(V v) throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BTreePersistentIndexedCache.this.serializer.write(byteArrayOutputStream, v);
            this.serialisedValue = byteArrayOutputStream.toByteArray();
        }

        public V getValue() throws Exception {
            if (this.value == null) {
                this.value = BTreePersistentIndexedCache.this.serializer.read(new ByteArrayInputStream(this.serialisedValue));
            }
            return this.value;
        }

        @Override
        protected int getType() {
            return 51;
        }

        @Override
        protected int getSize() {
            return 8 + this.size;
        }

        @Override
        public void read(DataInputStream dataInputStream) throws Exception {
            this.size = dataInputStream.readInt();
            int n = dataInputStream.readInt();
            this.serialisedValue = new byte[n];
            dataInputStream.readFully(this.serialisedValue);
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeInt(this.size);
            dataOutputStream.writeInt(this.serialisedValue.length);
            dataOutputStream.write(this.serialisedValue);
        }

        public boolean useNewValue(V v) throws Exception {
            boolean bl;
            this.setValue(v);
            boolean bl2 = bl = this.serialisedValue.length <= this.size;
            if (bl) {
                BTreePersistentIndexedCache.this.store.write(this);
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Lookup {
        final IndexBlock indexBlock;
        final IndexEntry entry;

        private Lookup(IndexBlock indexBlock, IndexEntry indexEntry) {
            this.indexBlock = indexBlock;
            this.entry = indexEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexEntry
    implements Comparable<IndexEntry> {
        long hashCode;
        BlockPointer dataBlock;
        BlockPointer childIndexBlock;

        private IndexEntry() {
        }

        private IndexEntry(long l) {
            this.hashCode = l;
        }

        @Override
        public int compareTo(IndexEntry indexEntry) {
            if (this.hashCode > indexEntry.hashCode) {
                return 1;
            }
            if (this.hashCode < indexEntry.hashCode) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexBlock
    extends BlockPayload {
        private final List<IndexEntry> entries = new ArrayList<IndexEntry>();
        private BlockPointer tailPos = new BlockPointer();
        private IndexBlock parent;
        private int parentEntryIndex;
        private IndexRoot root;

        private IndexBlock() {
        }

        @Override
        protected int getType() {
            return 119;
        }

        @Override
        protected int getSize() {
            return 12 + 24 * BTreePersistentIndexedCache.this.maxChildIndexEntries;
        }

        @Override
        public void read(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            this.entries.clear();
            for (int i = 0; i < n; ++i) {
                IndexEntry indexEntry = new IndexEntry();
                indexEntry.hashCode = dataInputStream.readLong();
                indexEntry.dataBlock = new BlockPointer(dataInputStream.readLong());
                indexEntry.childIndexBlock = new BlockPointer(dataInputStream.readLong());
                this.entries.add(indexEntry);
            }
            this.tailPos = new BlockPointer(dataInputStream.readLong());
        }

        @Override
        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeInt(this.entries.size());
            for (IndexEntry indexEntry : this.entries) {
                dataOutputStream.writeLong(indexEntry.hashCode);
                dataOutputStream.writeLong(indexEntry.dataBlock.getPos());
                dataOutputStream.writeLong(indexEntry.childIndexBlock.getPos());
            }
            dataOutputStream.writeLong(this.tailPos.getPos());
        }

        public void put(long l, BlockPointer blockPointer) throws Exception {
            IndexEntry indexEntry;
            int n = Collections.binarySearch(this.entries, new IndexEntry(l));
            if (n >= 0) {
                indexEntry = this.entries.get(n);
            } else {
                assert (this.tailPos.isNull());
                indexEntry = new IndexEntry();
                indexEntry.hashCode = l;
                indexEntry.childIndexBlock = new BlockPointer();
                n = -n - 1;
                this.entries.add(n, indexEntry);
            }
            indexEntry.dataBlock = blockPointer;
            BTreePersistentIndexedCache.this.store.write(this);
            this.maybeSplit();
        }

        private void maybeSplit() throws Exception {
            if (this.entries.size() > BTreePersistentIndexedCache.this.maxChildIndexEntries) {
                int n = this.entries.size() / 2;
                IndexEntry indexEntry = this.entries.remove(n);
                if (this.parent == null) {
                    this.parent = this.root.newRoot();
                }
                IndexBlock indexBlock = new IndexBlock();
                BTreePersistentIndexedCache.this.store.write(indexBlock);
                List<IndexEntry> list = this.entries.subList(n, this.entries.size());
                indexBlock.entries.addAll(list);
                list.clear();
                indexBlock.tailPos = this.tailPos;
                this.tailPos = indexEntry.childIndexBlock;
                indexEntry.childIndexBlock = new BlockPointer();
                this.parent.add(this, indexEntry, indexBlock);
            }
        }

        private void add(IndexBlock indexBlock, IndexEntry indexEntry, IndexBlock indexBlock2) throws Exception {
            int n = indexBlock.parentEntryIndex;
            if (n < this.entries.size()) {
                IndexEntry indexEntry2 = this.entries.get(n);
                assert (indexEntry2.childIndexBlock.equals(indexBlock.getPos()));
                indexEntry2.childIndexBlock = indexBlock2.getPos();
            } else {
                assert (n == this.entries.size() && (this.tailPos.isNull() || this.tailPos.equals(indexBlock.getPos())));
                this.tailPos = indexBlock2.getPos();
            }
            this.entries.add(n, indexEntry);
            indexEntry.childIndexBlock = indexBlock.getPos();
            BTreePersistentIndexedCache.this.store.write(this);
            this.maybeSplit();
        }

        public DataBlock get(K k) throws Exception {
            Lookup lookup = this.find(k);
            if (lookup.entry == null) {
                return null;
            }
            return BTreePersistentIndexedCache.this.store.read(lookup.entry.dataBlock, DataBlock.class);
        }

        public Lookup find(K k) throws Exception {
            MessageDigestStream messageDigestStream = new MessageDigestStream();
            BTreePersistentIndexedCache.this.keySerializer.write(messageDigestStream, k);
            long l = messageDigestStream.getChecksum();
            return this.find(l);
        }

        private Lookup find(long l) throws Exception {
            int n = Collections.binarySearch(this.entries, new IndexEntry(l));
            if (n >= 0) {
                return new Lookup(this, this.entries.get(n));
            }
            BlockPointer blockPointer = (n = -n - 1) == this.entries.size() ? this.tailPos : this.entries.get((int)n).childIndexBlock;
            if (blockPointer.isNull()) {
                return new Lookup(this, null);
            }
            IndexBlock indexBlock = BTreePersistentIndexedCache.this.load(blockPointer, this.root, this, n);
            return indexBlock.find(l);
        }

        public void remove(IndexEntry indexEntry) throws Exception {
            int n = this.entries.indexOf(indexEntry);
            assert (n >= 0);
            this.entries.remove(n);
            BTreePersistentIndexedCache.this.store.write(this);
            if (indexEntry.childIndexBlock.isNull()) {
                this.maybeMerge();
            } else {
                IndexBlock indexBlock = BTreePersistentIndexedCache.this.load(indexEntry.childIndexBlock, this.root, this, n);
                indexBlock = indexBlock.findHighestLeaf();
                IndexEntry indexEntry2 = indexBlock.entries.remove(indexBlock.entries.size() - 1);
                indexEntry2.childIndexBlock = indexEntry.childIndexBlock;
                this.entries.add(n, indexEntry2);
                BTreePersistentIndexedCache.this.store.write(indexBlock);
                indexBlock.maybeMerge();
            }
        }

        private void maybeMerge() throws Exception {
            if (this.parent == null) {
                if (this.entries.size() == 0 && !this.tailPos.isNull()) {
                    BTreePersistentIndexedCache.this.header.index.setRootPos(this.tailPos);
                    BTreePersistentIndexedCache.this.store.remove(this);
                }
                return;
            }
            if (this.entries.size() >= BTreePersistentIndexedCache.this.minIndexChildNodes) {
                return;
            }
            IndexBlock indexBlock = this.parent.getPrevious(this);
            if (indexBlock != null) {
                assert (this.entries.size() + indexBlock.entries.size() <= BTreePersistentIndexedCache.this.maxChildIndexEntries * 2);
                if (indexBlock.entries.size() > BTreePersistentIndexedCache.this.minIndexChildNodes) {
                    indexBlock.mergeFrom(this);
                    indexBlock.maybeSplit();
                    return;
                }
                indexBlock.mergeFrom(this);
                this.parent.maybeMerge();
                return;
            }
            IndexBlock indexBlock2 = this.parent.getNext(this);
            if (indexBlock2 != null) {
                assert (this.entries.size() + indexBlock2.entries.size() <= BTreePersistentIndexedCache.this.maxChildIndexEntries * 2);
                if (indexBlock2.entries.size() > BTreePersistentIndexedCache.this.minIndexChildNodes) {
                    this.mergeFrom(indexBlock2);
                    this.maybeSplit();
                    return;
                }
                this.mergeFrom(indexBlock2);
                this.parent.maybeMerge();
                return;
            }
            throw new IllegalStateException(String.format("%s does not have any siblings.", this.getBlock()));
        }

        private void mergeFrom(IndexBlock indexBlock) throws Exception {
            IndexEntry indexEntry = this.parent.entries.remove(this.parentEntryIndex);
            if (indexBlock.getPos().equals(this.parent.tailPos)) {
                this.parent.tailPos = this.getPos();
            } else {
                IndexEntry indexEntry2 = this.parent.entries.get(this.parentEntryIndex);
                assert (indexEntry2.childIndexBlock.equals(indexBlock.getPos()));
                indexEntry2.childIndexBlock = this.getPos();
            }
            this.entries.add(indexEntry);
            this.entries.addAll(indexBlock.entries);
            indexEntry.childIndexBlock = this.tailPos;
            this.tailPos = indexBlock.tailPos;
            BTreePersistentIndexedCache.this.store.write(this.parent);
            BTreePersistentIndexedCache.this.store.write(this);
            BTreePersistentIndexedCache.this.store.remove(indexBlock);
        }

        private IndexBlock getNext(IndexBlock indexBlock) throws Exception {
            int n = indexBlock.parentEntryIndex + 1;
            if (n > this.entries.size()) {
                return null;
            }
            if (n == this.entries.size()) {
                return BTreePersistentIndexedCache.this.load(this.tailPos, this.root, this, n);
            }
            return BTreePersistentIndexedCache.this.load(this.entries.get((int)n).childIndexBlock, this.root, this, n);
        }

        private IndexBlock getPrevious(IndexBlock indexBlock) throws Exception {
            int n = indexBlock.parentEntryIndex - 1;
            if (n < 0) {
                return null;
            }
            return BTreePersistentIndexedCache.this.load(this.entries.get((int)n).childIndexBlock, this.root, this, n);
        }

        private IndexBlock findHighestLeaf() throws Exception {
            if (this.tailPos.isNull()) {
                return this;
            }
            return BTreePersistentIndexedCache.this.load(this.tailPos, this.root, this, this.entries.size()).findHighestLeaf();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HeaderBlock
    extends BlockPayload {
        private IndexRoot index;

        private HeaderBlock() {
            this.index = new IndexRoot(this);
        }

        @Override
        protected int getType() {
            return 85;
        }

        @Override
        protected int getSize() {
            return 10;
        }

        @Override
        protected void read(DataInputStream dataInputStream) throws Exception {
            this.index.rootPos = new BlockPointer(dataInputStream.readLong());
            short s = dataInputStream.readShort();
            if (s != BTreePersistentIndexedCache.this.maxChildIndexEntries) {
                throw this.blockCorruptedException();
            }
        }

        @Override
        protected void write(DataOutputStream dataOutputStream) throws Exception {
            dataOutputStream.writeLong(this.index.rootPos.getPos());
            dataOutputStream.writeShort(BTreePersistentIndexedCache.this.maxChildIndexEntries);
        }

        public IndexBlock getRoot() throws Exception {
            return this.index.getRoot();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexRoot {
        private BlockPointer rootPos = new BlockPointer();
        private HeaderBlock owner;

        private IndexRoot(HeaderBlock headerBlock) {
            this.owner = headerBlock;
        }

        public void setRootPos(BlockPointer blockPointer) {
            this.rootPos = blockPointer;
            BTreePersistentIndexedCache.this.store.write(this.owner);
        }

        public IndexBlock getRoot() {
            return BTreePersistentIndexedCache.this.load(this.rootPos, this, null, 0);
        }

        public IndexBlock newRoot() {
            IndexBlock indexBlock = new IndexBlock();
            BTreePersistentIndexedCache.this.store.write(indexBlock);
            this.setRootPos(indexBlock.getPos());
            return indexBlock;
        }
    }
}

