/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.GradleException;
import org.gradle.cache.PersistentStateCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.FileAccess;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStateCache<T>
implements PersistentStateCache<T> {
    private final FileAccess fileAccess;
    private final Serializer<T> serializer;
    private final File cacheFile;

    public SimpleStateCache(File file, FileAccess fileAccess, Serializer<T> serializer) {
        this.cacheFile = file;
        this.fileAccess = fileAccess;
        this.serializer = serializer;
    }

    @Override
    public T get() {
        return this.fileAccess.readFromFile(new Factory<T>(){

            public T create() {
                return SimpleStateCache.this.deserialize();
            }
        });
    }

    @Override
    public void set(final T t) {
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                SimpleStateCache.this.serialize(t);
            }
        });
    }

    @Override
    public void update(final PersistentStateCache.UpdateAction<T> updateAction) {
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                Object object = SimpleStateCache.this.deserialize();
                Object object2 = updateAction.update(object);
                SimpleStateCache.this.serialize(object2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(T t) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.cacheFile));
            try {
                this.serializer.write(bufferedOutputStream, t);
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not write cache value to '%s'.", this.cacheFile), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T deserialize() {
        if (!this.cacheFile.isFile()) {
            return null;
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.cacheFile));
            try {
                T t = this.serializer.read(bufferedInputStream);
                return t;
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (Exception exception) {
            throw new GradleException(String.format("Could not read cache value from '%s'.", this.cacheFile), exception);
        }
    }
}

