/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnDemandFileAccess
extends AbstractFileAccess {
    private final String displayName;
    private final FileLockManager manager;
    private final File targetFile;

    public OnDemandFileAccess(File file, String string, FileLockManager fileLockManager) {
        this.targetFile = file;
        this.displayName = string;
        this.manager = fileLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readFromFile(Factory<? extends T> factory) throws LockTimeoutException {
        FileLock fileLock = this.manager.lock(this.targetFile, FileLockManager.LockMode.Shared, this.displayName);
        try {
            T t = fileLock.readFromFile(factory);
            return t;
        }
        finally {
            fileLock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(Runnable runnable) throws LockTimeoutException {
        FileLock fileLock = this.manager.lock(this.targetFile, FileLockManager.LockMode.Exclusive, this.displayName);
        try {
            fileLock.writeToFile(runnable);
        }
        finally {
            fileLock.close();
        }
    }
}

