/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.UnitOfWorkParticipant;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiProcessSafePersistentIndexedCache<K, V>
implements PersistentIndexedCache<K, V>,
UnitOfWorkParticipant,
Closeable {
    private final FileAccess fileAccess;
    private final Factory<BTreePersistentIndexedCache<K, V>> factory;
    private BTreePersistentIndexedCache<K, V> cache;

    public MultiProcessSafePersistentIndexedCache(Factory<BTreePersistentIndexedCache<K, V>> factory, FileAccess fileAccess) {
        this.factory = factory;
        this.fileAccess = fileAccess;
    }

    @Override
    public V get(final K k) {
        final PersistentIndexedCache<K, V> persistentIndexedCache = this.getCache();
        return (V)this.fileAccess.readFromFile(new Factory<V>(){

            public V create() {
                return persistentIndexedCache.get(k);
            }
        });
    }

    @Override
    public void put(final K k, final V v) {
        final PersistentIndexedCache<K, V> persistentIndexedCache = this.getCache();
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                persistentIndexedCache.put(k, v);
            }
        });
    }

    @Override
    public void remove(final K k) {
        final PersistentIndexedCache<K, V> persistentIndexedCache = this.getCache();
        this.fileAccess.writeToFile(new Runnable(){

            public void run() {
                persistentIndexedCache.remove(k);
            }
        });
    }

    @Override
    public void onStartWork(String string) {
    }

    @Override
    public void onEndWork() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.cache != null) {
            try {
                this.fileAccess.writeToFile(new Runnable(){

                    public void run() {
                        MultiProcessSafePersistentIndexedCache.this.cache.close();
                    }
                });
            }
            finally {
                this.cache = null;
            }
        }
    }

    private PersistentIndexedCache<K, V> getCache() {
        if (this.cache == null) {
            this.fileAccess.writeToFile(new Runnable(){

                public void run() {
                    MultiProcessSafePersistentIndexedCache.this.cache = (BTreePersistentIndexedCache)MultiProcessSafePersistentIndexedCache.this.factory.create();
                }
            });
        }
        return this.cache;
    }
}

