/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.internal.DefaultCacheAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistentDirectoryStore
implements PersistentCache {
    private final File dir;
    private final FileLockManager.LockMode lockMode;
    private final FileLockManager lockManager;
    private final String displayName;
    private DefaultCacheAccess cacheAccess;

    public DefaultPersistentDirectoryStore(File file, String string, FileLockManager.LockMode lockMode, FileLockManager fileLockManager) {
        this.dir = file;
        this.lockMode = lockMode;
        this.lockManager = fileLockManager;
        this.displayName = string != null ? String.format("%s (%s)", string, file) : String.format("cache directory %s (%s)", file.getName(), file);
    }

    public DefaultPersistentDirectoryStore open() {
        this.dir.mkdirs();
        this.cacheAccess = new DefaultCacheAccess(this.displayName, this.getLockTarget(), this.lockManager);
        try {
            this.cacheAccess.open(this.lockMode);
            try {
                this.init();
            }
            catch (Throwable throwable) {
                this.cacheAccess.close();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            throw new CacheOpenException(String.format("Could not open %s.", this), throwable);
        }
        return this;
    }

    protected File getLockTarget() {
        return this.dir;
    }

    protected void init() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.cacheAccess != null) {
            try {
                this.cacheAccess.close();
            }
            finally {
                this.cacheAccess = null;
            }
        }
    }

    protected FileLock getLock() {
        return this.cacheAccess.getFileLock();
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(File file, Class<K> clazz, Class<V> clazz2) {
        return this.cacheAccess.newCache(file, clazz, clazz2);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(File file, Class<K> clazz, Serializer<V> serializer) {
        return this.cacheAccess.newCache(file, clazz, serializer);
    }

    @Override
    public <T> T useCache(String string, Factory<? extends T> factory) {
        return this.cacheAccess.useCache(string, factory);
    }

    @Override
    public void useCache(String string, Runnable runnable) {
        this.cacheAccess.useCache(string, runnable);
    }

    @Override
    public <T> T longRunningOperation(String string, Factory<? extends T> factory) {
        return this.cacheAccess.longRunningOperation(string, factory);
    }

    @Override
    public void longRunningOperation(String string, Runnable runnable) {
        this.cacheAccess.longRunningOperation(string, runnable);
    }
}

