/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.gradle.CacheUsage;
import org.gradle.api.Action;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistentDirectoryCache
extends DefaultPersistentDirectoryStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryCache.class);
    private final File propertiesFile;
    private final Properties properties = new Properties();
    private final CacheUsage cacheUsage;
    private final Action<? super PersistentCache> initAction;
    private final CacheValidator validator;

    public DefaultPersistentDirectoryCache(File file, String string, CacheUsage cacheUsage, CacheValidator cacheValidator, Map<String, ?> map, FileLockManager.LockMode lockMode, Action<? super PersistentCache> action, FileLockManager fileLockManager) {
        super(file, string, lockMode, fileLockManager);
        if (lockMode == FileLockManager.LockMode.None) {
            throw new UnsupportedOperationException("Locking mode None is not supported.");
        }
        this.validator = cacheValidator;
        this.cacheUsage = cacheUsage;
        this.initAction = action;
        this.propertiesFile = new File(file, "cache.properties");
        this.properties.putAll(map);
    }

    @Override
    protected File getLockTarget() {
        return this.propertiesFile;
    }

    @Override
    protected void init() throws IOException {
        boolean bl = this.determineIfCacheIsValid(this.getLock());
        if (!bl) {
            this.getLock().writeToFile(new Runnable(){

                public void run() {
                    DefaultPersistentDirectoryCache.this.buildCacheDir(DefaultPersistentDirectoryCache.this.initAction, DefaultPersistentDirectoryCache.this.getLock());
                }
            });
        }
    }

    private void buildCacheDir(Action<? super PersistentCache> action, FileLock fileLock) {
        for (File file : this.getBaseDir().listFiles()) {
            if (fileLock.isLockFile(file) || file.equals(this.propertiesFile)) continue;
            GFileUtils.forceDelete(file);
        }
        if (action != null) {
            action.execute(this);
        }
        GUtil.saveProperties(this.properties, this.propertiesFile);
    }

    private boolean determineIfCacheIsValid(FileLock fileLock) throws IOException {
        if (this.cacheUsage != CacheUsage.ON) {
            LOGGER.debug("Invalidating {} as cache usage is set to rebuild.", (Object)this);
            return false;
        }
        if (this.validator != null && !this.validator.isValid()) {
            LOGGER.debug("Invalidating {} as cache validator return false.", (Object)this);
            return false;
        }
        if (!fileLock.getUnlockedCleanly()) {
            LOGGER.debug("Invalidating {} as it was not closed cleanly.", (Object)this);
            return false;
        }
        Properties properties = GUtil.loadProperties(this.propertiesFile);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (entry.getValue().toString().equals(properties.getProperty(entry.getKey().toString()))) continue;
            LOGGER.debug("Invalidating {} as cache property {} has changed value.", (Object)this, entry.getKey());
            return false;
        }
        return true;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

